/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.VideoPlaylistFragment;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.models.Videos;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import java.util.ArrayList;

public class VideosViewHolder
extends FlybitsViewHolder<Videos> {
    private View thisView;
    private ImageView[] singlePlaceHolderViews;
    private ImageView[] doublePlaceHolderViews;
    private ImageView[] triplePlaceHolderViews;
    private View tripleContainer;
    private View doubleContainer;
    private View singleContainer;
    private View callToActionView;

    public VideosViewHolder(View view) {
        super(view);
        this.thisView = view;
        this.triplePlaceHolderViews = new ImageView[]{(ImageView)view.findViewById(R.id.flybits_con_item_template_videos_imgBig), (ImageView)view.findViewById(R.id.flybits_con_item_template_videos_imgTR), (ImageView)view.findViewById(R.id.flybits_con_item_template_videos_imgBR)};
        this.doublePlaceHolderViews = new ImageView[]{(ImageView)view.findViewById(R.id.flybits_con_item_template_videos_imgLeft), (ImageView)view.findViewById(R.id.flybits_con_item_template_videos_imgRight)};
        this.singlePlaceHolderViews = new ImageView[]{(ImageView)view.findViewById(R.id.flybits_con_item_template_videos_single)};
        this.tripleContainer = view.findViewById(R.id.flybits_con_item_template_videos_triple);
        this.doubleContainer = view.findViewById(R.id.flybits_con_item_template_videos_double);
        this.singleContainer = view.findViewById(R.id.flybits_con_item_template_videos_single_container);
        this.callToActionView = view.findViewById(R.id.flybits_con_item_template_videos_callToAction);
    }

    @Override
    public void bindData(Videos data, final FlybitsNavigator flybitsNavigator) {
        ImageView[] placeHolderViews;
        final ArrayList videos = data.videos.getList();
        this.tripleContainer.setVisibility(videos.size() > 2 ? 0 : 8);
        this.doubleContainer.setVisibility(videos.size() == 2 ? 0 : 8);
        this.singleContainer.setVisibility(videos.size() == 1 ? 0 : 8);
        this.callToActionView.setVisibility(videos.size() > 1 ? 0 : 8);
        switch (videos.size()) {
            case 0: {
                return;
            }
            case 1: {
                TextView titleTextView = (TextView)this.thisView.findViewById(R.id.flybits_con_item_template_videos_txtTitle);
                TextView durationTextView = (TextView)this.thisView.findViewById(R.id.flybits_con_item_template_videos_txtDuration);
                ((Video)videos.get(0)).populateViews(flybitsNavigator, titleTextView, durationTextView, this.singlePlaceHolderViews[0], this.thisView);
                return;
            }
            case 2: {
                placeHolderViews = this.doublePlaceHolderViews;
                break;
            }
            default: {
                placeHolderViews = this.triplePlaceHolderViews;
            }
        }
        for (int i = 0; i < placeHolderViews.length; ++i) {
            ImageView view = placeHolderViews[i];
            if (i < videos.size()) {
                Video video = (Video)videos.get(i);
                video.populateViews(flybitsNavigator, view, (View)view);
                continue;
            }
            view.setImageDrawable(ContextCompat.getDrawable((Context)view.getContext(), (int)17301658));
            view.setOnClickListener(null);
        }
        this.callToActionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlaylistFragment fragment = VideoPlaylistFragment.newInstance(videos);
                flybitsNavigator.openFragment(fragment);
            }
        });
    }
}

