/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;
import java.util.Locale;

public class OnboardingPage
extends BaseTemplate {
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageUrl;
    public static final Parcelable.Creator<OnboardingPage> CREATOR = new Parcelable.Creator<OnboardingPage>(){

        public OnboardingPage createFromParcel(Parcel in) {
            return new OnboardingPage(in);
        }

        public OnboardingPage[] newArray(int size) {
            return new OnboardingPage[size];
        }
    };

    public OnboardingPage() {
    }

    protected OnboardingPage(Parcel in) {
        super(in);
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.imageUrl = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.description, flags);
        dest.writeString(this.imageUrl);
    }

    public void populateViews(TextView titleTextView) {
        String onBoardingTitle = this.title.getValue();
        String displayedTitle = String.format(Locale.getDefault(), titleTextView.getContext().getString(R.string.flybits_con_item_template_on_boarding_title_format), onBoardingTitle);
        titleTextView.setText((CharSequence)displayedTitle);
    }

    public void populateViews(TextView titleTextView, TextView bodyTextView, ImageView logoImageView) {
        titleTextView.setText((CharSequence)this.title.getValue());
        bodyTextView.setText((CharSequence)this.description.getValue());
        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)logoImageView.getContext()).load(this.imageUrl).apply(options).into(logoImageView);
    }
}

