/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class Audio
extends BaseTemplate
implements Parcelable {
    public String _id;
    public LocalizedValue title;
    public LocalizedValue description;
    public String duration;
    public String sourceURL;
    public String imageURL;
    public static final Parcelable.Creator<Audio> CREATOR = new Parcelable.Creator<Audio>(){

        public Audio createFromParcel(Parcel in) {
            return new Audio(in);
        }

        public Audio[] newArray(int size) {
            return new Audio[size];
        }
    };

    public Audio() {
    }

    protected Audio(Parcel in) {
        super(in);
        this._id = in.readString();
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.duration = in.readString();
        this.sourceURL = in.readString();
        this.imageURL = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this._id);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.description, flags);
        dest.writeString(this.duration);
        dest.writeString(this.sourceURL);
        dest.writeString(this.imageURL);
    }

    public int describeContents() {
        return 0;
    }

    public void populateViews(TextView txtTitle, TextView txtDescription, TextView txtDuration, ImageView imgImage) {
        txtTitle.setText((CharSequence)this.title.getValue());
        txtDescription.setText((CharSequence)this.description.getValue());
        txtDuration.setVisibility(!TextUtils.isEmpty((CharSequence)this.duration) ? 0 : 8);
        txtDuration.setText((CharSequence)this.duration);
        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)imgImage.getContext()).load(this.imageURL).apply(options).into(imgImage);
    }
}

