/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.services;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.flybits.android.push.FlybitsNotificationManager;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.analytics.PushAnalytics;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.ConciergeActivity;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;
import org.json.JSONObject;

public class FlybitsConMessagingService
extends FirebaseMessagingService {
    private static final String JSON_KEY_URL = "url";
    private static final String JSON_KEY_VALUE = "value";
    private static final String JSON_KEY_CONTENT = "contentId";
    private static final int NOTIFICATION_ID = 753;
    private PushAnalytics pushAnalytics;

    public void onCreate() {
        super.onCreate();
        this.pushAnalytics = new PushAnalytics(this.getApplicationContext());
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        PushManager.parsePushNotification((Context)this.getApplicationContext(), (Map)remoteMessage.getData(), (ObjectResultCallback)new ObjectResultCallback<Push>(){

            public void onSuccess(Push item) {
                Context context = FlybitsConMessagingService.this.getApplicationContext();
                Intent intent = new Intent();
                switch (item.getAction()) {
                    case ADDED: {
                        intent.setAction("flybits_con_broadcast_content_add");
                        break;
                    }
                    case REMOVED: {
                        intent.setAction("flybits_con_broadcast_content_remove");
                        break;
                    }
                    case UPDATED: {
                        intent.setAction("flybits_con_broadcast_content_update");
                        break;
                    }
                    case RULE_UPDATED: {
                        intent.setAction("flybits_con_broadcast_rule_update");
                        break;
                    }
                    case STATUS_CHANGED: {
                        intent.setAction("flybits_con_broadcast_rule_state");
                        break;
                    }
                    case CUSTOM: {
                        FlybitsConMessagingService.this.buildNotification(item);
                        break;
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)intent.getAction())) {
                    context.sendBroadcast(intent);
                }
            }

            public void onException(FlybitsException exception) {
                Logger.exception((String)FlybitsConMessagingService.class.getSimpleName(), (Exception)((Object)exception));
            }
        });
    }

    public int pushNotificationIconRes() {
        return R.mipmap.ic_flybits_notification;
    }

    private void buildNotification(Push item) {
        FlybitsNotificationManager builder = new FlybitsNotificationManager.Simplifier(this.getApplicationContext(), item.getId(), item.getTitle(), item.getMessage(), this.pushNotificationIconRes()).build();
        Intent intent = new Intent(this.getApplicationContext(), ConciergeActivity.class);
        intent.putExtra("flybits_con_push_id", item.getId());
        try {
            String contentId;
            JSONObject jsonObject = new JSONObject(item.getCustomFieldsAsString());
            String url = jsonObject.isNull(JSON_KEY_URL) ? null : jsonObject.getString(JSON_KEY_URL);
            String string2 = contentId = jsonObject.isNull(JSON_KEY_CONTENT) ? null : jsonObject.getJSONObject(JSON_KEY_CONTENT).getString(JSON_KEY_VALUE);
            if (url != null) {
                intent.putExtra("flybits_con_push_content_url", url);
            } else if (contentId != null) {
                intent.putExtra("flybits_con_push_content_id", contentId);
            }
        }
        catch (Exception e) {
            Logger.exception((String)FlybitsConMessagingService.class.getSimpleName(), (Exception)e);
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)753, (Intent)intent, (int)0x8000000);
        builder.get().setContentIntent(pendingIntent);
        builder.show();
        this.pushAnalytics.trackViewed(item, System.currentTimeMillis());
    }

    public void onNewToken(String recentToken) {
        super.onNewToken(recentToken);
        InternalPreferences.savePushToken(this.getApplicationContext(), recentToken);
    }
}

