/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Twitter;
import com.flybits.concierge.viewmodels.TwitterViewModel;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.CompactTweetView;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.SearchTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TweetTimelineListAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Twitters
extends BaseTemplate {
    private static final int MAX_TWEETS = 5;
    public PagedArray<Twitter> twitter;
    private TwitterViewModel twitterViewModel;
    private List<String> twitterNames = new ArrayList<String>();
    private String twitterNameKey;
    private LinearLayout viewContainer;
    private boolean isLoading;
    private TweetTimelineListAdapter adapter;
    private FlybitsTwitterObserver observer = new FlybitsTwitterObserver();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    public static final Parcelable.Creator<Twitters> CREATOR = new Parcelable.Creator<Twitters>(){

        public Twitters createFromParcel(Parcel in) {
            return new Twitters(in);
        }

        public Twitters[] newArray(int size) {
            return new Twitters[size];
        }
    };

    public Twitters() {
    }

    protected Twitters(Parcel in) {
        super(in);
        this.twitter = (PagedArray)in.readParcelable(PagedArray.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(this.twitter, flags);
    }

    public void generateTweets(final @NonNull LinearLayout container) {
        container.removeAllViews();
        this.twitterViewModel = (TwitterViewModel)ViewModelProviders.of((FragmentActivity)((FragmentActivity)container.getContext())).get(TwitterViewModel.class);
        this.twitterNames.clear();
        for (Twitter names : this.twitter.getList()) {
            this.twitterNames.add(names.username);
        }
        this.twitterNameKey = TextUtils.join((CharSequence)"+", this.twitterNames);
        List<Tweet> tweetList = this.twitterViewModel.getTweetList(this.twitterNameKey);
        List<View> tweetViewList = this.tweetsToViews(container.getContext(), tweetList);
        if (tweetViewList.size() == 0) {
            if (this.isLoading) {
                return;
            }
            if (!Utils.isOnline((Context)container.getContext())) {
                this.isLoading = false;
                this.presentErrorView(container);
                return;
            }
            View loadingView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.flybits_con_item_template_twitter_loading, (ViewGroup)container, false);
            container.addView(loadingView);
            ProgressBar progressBar = (ProgressBar)loadingView.findViewById(R.id.flybits_con_item_template_twitter_loading_progress);
            Drawable spinner = progressBar.getIndeterminateDrawable().mutate();
            spinner.setColorFilter(ContextCompat.getColor((Context)container.getContext(), (int)R.color.flybits_con_heading_text_color), PorterDuff.Mode.SRC_IN);
            progressBar.setProgressDrawable(spinner);
            String query = "from:";
            if (this.twitterNames.size() > 1) {
                query = query + TextUtils.join((CharSequence)" OR from:", this.twitterNames);
            } else if (this.twitterNames.size() == 1) {
                query = query + this.twitterNames.get(0);
            }
            try {
                final SearchTimeline searchTimeline = new SearchTimeline.Builder().query(query).maxItemsPerRequest(Integer.valueOf(5)).build();
                this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Twitters.this.isLoading = true;
                        Twitters.this.adapter = new TweetTimelineListAdapter(container.getContext(), (Timeline)searchTimeline);
                        Twitters.this.adapter.registerDataSetObserver((DataSetObserver)Twitters.this.observer);
                    }
                });
            }
            catch (Exception e) {
                Logger.exception((String)Twitters.class.getSimpleName(), (Exception)e);
                this.presentErrorView(container);
                return;
            }
            this.viewContainer = container;
        } else {
            for (View v : tweetViewList) {
                if (v.getParent() != null) {
                    ((LinearLayout)v.getParent()).removeAllViews();
                }
                container.addView(v);
            }
        }
    }

    private void presentErrorView(LinearLayout container) {
        container.removeAllViews();
        View failedView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.flybits_con_item_template_twitter_failed, (ViewGroup)container, false);
        container.addView(failedView);
    }

    private List<View> tweetsToViews(Context context, List<Tweet> tweets) {
        ArrayList<View> views = new ArrayList<View>();
        for (Tweet tweet : tweets) {
            CompactTweetView tv = new CompactTweetView(context, tweet, R.style.tw__TweetLightStyle);
            views.add((View)tv);
        }
        return views;
    }

    public class FlybitsTwitterObserver
    extends DataSetObserver {
        public void onChanged() {
            super.onChanged();
            if (Twitters.this.twitterViewModel == null) {
                Twitters.this.isLoading = false;
                return;
            }
            final List<Tweet> tweetList = Twitters.this.twitterViewModel.getTweetList(Twitters.this.twitterNameKey);
            Twitters.this.adapter.unregisterDataSetObserver((DataSetObserver)Twitters.this.observer);
            for (int i = 0; i < Twitters.this.adapter.getCount(); ++i) {
                tweetList.add((Tweet)Twitters.this.adapter.getItem(i));
            }
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Twitters.this.viewContainer.removeAllViews();
                    List tweetViewList = Twitters.this.tweetsToViews(Twitters.this.viewContainer.getContext(), tweetList);
                    for (View v : tweetViewList) {
                        Twitters.this.viewContainer.addView(v);
                    }
                    Twitters.this.viewContainer = null;
                    Twitters.this.isLoading = false;
                }
            });
        }

        public void onInvalidated() {
            super.onInvalidated();
            Twitters.this.isLoading = false;
        }
    }
}

