/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.ScheduleSegment;
import com.flybits.concierge.models.Text;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import com.flybits.concierge.viewholders.ScheduleSegmentViewHolder;
import com.flybits.concierge.viewholders.ScheduleTitleViewHolder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ScheduleFeedFragment
extends Fragment {
    private static final String ARG_SCHEDULE = "flybits_con_arg_schedule";
    private static final int DAYS_SHOWN = 7;
    private ConciergeFragment conciergeFragment;
    private RecyclerView recyclerView;
    private Schedule schedule;
    private Map<String, LinkedList<ScheduleSegment>> weekSegments;
    private List<BaseTemplate> data;

    public static ScheduleFeedFragment newInstance(Schedule schedule) {
        ScheduleFeedFragment fragment = new ScheduleFeedFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_SCHEDULE, (Parcelable)schedule);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.schedule = (Schedule)this.getArguments().getParcelable(ARG_SCHEDULE);
            if (this.schedule != null) {
                this.weekSegments = this.schedule.generateSegmentList();
                this.data = new ArrayList<BaseTemplate>();
                Calendar now = Calendar.getInstance();
                for (int i = 0; i < 7; ++i) {
                    String weekDay = Utils.getWeekDayString(now.getTime());
                    LinkedList<ScheduleSegment> todaySegments = this.weekSegments.get(weekDay);
                    if (todaySegments != null) {
                        Text title = new Text();
                        String lang = Locale.getDefault().getLanguage();
                        LocalizedValue value = new LocalizedValue(lang, lang);
                        value.addValue(lang, Utils.getDateString(now.getTime()));
                        title.header = value;
                        this.data.add(title);
                        for (ScheduleSegment segment : todaySegments) {
                            this.data.add(segment);
                        }
                    }
                    now.set(6, now.get(6) + 1);
                }
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_schedule_feed, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.flybits_con_fragment_schedule_feed_lytRecycler);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recyclerView.setAdapter((RecyclerView.Adapter)new SegmentAdapter());
        this.conciergeFragment = Utils.getConciergeFragment(this.getActivity());
    }

    private class SegmentAdapter
    extends RecyclerView.Adapter<FlybitsViewHolder<? extends BaseTemplate>> {
        private SegmentAdapter() {
        }

        @NonNull
        public FlybitsViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ScheduleCellType type = ScheduleCellType.values()[viewType];
            switch (type) {
                case TITLE: {
                    return new ScheduleTitleViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule_title, parent, false));
                }
                case SEGMENT: {
                    return new ScheduleSegmentViewHolder(ScheduleFeedFragment.this.conciergeFragment, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule_segment, parent, false));
                }
            }
            return null;
        }

        public void onBindViewHolder(@NonNull FlybitsViewHolder holder, int position) {
            holder.bindData((BaseTemplate)ScheduleFeedFragment.this.data.get(position), ScheduleFeedFragment.this.conciergeFragment);
            if (holder instanceof ScheduleSegmentViewHolder) {
                ((ScheduleSegmentViewHolder)holder).setLast(position == this.getItemCount() - 1 || ScheduleFeedFragment.this.data.get(position + 1) instanceof Text);
            }
        }

        public int getItemCount() {
            return ScheduleFeedFragment.this.data.size();
        }

        public int getItemViewType(int position) {
            return (ScheduleFeedFragment.this.data.get(position) instanceof ScheduleSegment ? ScheduleCellType.SEGMENT : ScheduleCellType.TITLE).ordinal();
        }
    }

    private static enum ScheduleCellType {
        TITLE,
        SEGMENT;

    }
}

