package com.flybits.internal.db

import android.arch.persistence.room.Dao
import android.arch.persistence.room.Delete
import android.arch.persistence.room.Insert
import android.arch.persistence.room.OnConflictStrategy.REPLACE
import android.arch.persistence.room.Query
import com.flybits.commons.library.models.CtxData

@Dao
interface CtxDataDAO {
    @Query("SELECT * from ctxData")
    fun getAll(): List<CtxData>

    @Insert(onConflict = REPLACE)
    fun insert(basicData: CtxData)

    @Query("DELETE from ctxData")
    fun deleteAll()

    @Delete
    fun deleteMany(ctxData: Collection<CtxData>)
}