package com.flybits.commons.library.exceptions;

/**
 *  The {@code InvalidFlybitsManagerException} is thrown when an attempt to initiate an invalid
 *  {@link InvalidFlybitsManagerException} is created. {@link InvalidFlybitsManagerException} must contain
 *  success/fail callbacks as well as {@link com.flybits.commons.library.api.FlybitsScope}.
 *
 * @since 1.0.0
 */
public class InvalidFlybitsManagerException extends RuntimeException {

    /**
     * Constructs an empty {@code InvalidFlybitsManagerException}.
     */
    public InvalidFlybitsManagerException(){}

    /**
     * Constructs a new {@code InvalidFlybitsManagerException} with a specified message indicating
     * why the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public InvalidFlybitsManagerException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code InvalidFlybitsManagerException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public InvalidFlybitsManagerException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code InvalidFlybitsManagerException} with the specified detail message and
     * the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public InvalidFlybitsManagerException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}