/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeLogin
extends IDeserializer<User> {
    private static final String CURRENT_DEVICE_ID = "currentDeviceId";
    private static final String IS_CONFIRMED = "isConfirmed";

    @Override
    public String toJson(User obj) {
        JSONObject object = new JSONObject();
        if (obj.getId() != null) {
            try {
                object.put("id", (Object)obj.getId());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (obj.getEmail() != null) {
            try {
                object.put("email", (Object)obj.getEmail());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (obj.getDeviceID() != null) {
            try {
                object.put(CURRENT_DEVICE_ID, (Object)obj.getDeviceID());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (obj.getFirstName() != null) {
            try {
                object.put("firstName", (Object)obj.getFirstName());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (obj.getLastName() != null) {
            try {
                object.put("lastName", (Object)obj.getLastName());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        try {
            object.put(IS_CONFIRMED, obj.isVerified());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("isOptedIn", obj.isOptedIn());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("isActive", obj.isActive());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public User fromJson(JSONObject jObj) {
        try {
            if (!(jObj.isNull("id") || jObj.isNull("email") || jObj.isNull(CURRENT_DEVICE_ID))) {
                String id = jObj.getString("id");
                String email = jObj.getString("email");
                String deviceID = jObj.getString(CURRENT_DEVICE_ID);
                User user = new User(id, email, deviceID);
                if (!jObj.isNull("firstName") && !jObj.isNull("lastName")) {
                    user.setName(jObj.getString("firstName"), jObj.getString("lastName"));
                }
                if (!jObj.isNull(IS_CONFIRMED)) {
                    user.setIsVerified(jObj.getBoolean(IS_CONFIRMED));
                }
                if (jObj.has("isOptedIn")) {
                    user.setOptedIn(jObj.getBoolean("isOptedIn"));
                } else {
                    user.setOptedIn(true);
                }
                if (jObj.has("isActive")) {
                    user.setActive(jObj.getBoolean("isActive"));
                } else {
                    user.setActive(true);
                }
                return user;
            }
        }
        catch (JSONException e) {
            Logger.exception("DeserializeLogin.fromJson", (Exception)((Object)e));
        }
        return null;
    }

    @Override
    public User fromJson(JSONArray jsonObject) {
        return null;
    }
}

