package com.flybits.commons.library.exceptions;

/**
 *  The {@code NotConnectedException} is thrown whenever the SDK detects that the user is attempting
 *  to access a Flybits resource while they are not connected to the Flybits system.
 *
 *  @since 1.0.0
 */
public class NotConnectedException extends FlybitsException {

    /**
     * Constructs an empty {@code MissingProjectIDException}.
     */
    public NotConnectedException(){}

    /**
     * Constructs a new {@code MissingProjectIDException} with a specified message indicating why
     * the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public NotConnectedException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code MissingProjectIDException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public NotConnectedException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code MissingProjectIDException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public NotConnectedException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}