package com.flybits.commons.library.exceptions;

/**
 * The {@code APIUsageExceededException} class represents an exception that was thrown by the
 * Flybits ecosystem that indicates that this project has exceed the limit on the number of API that
 * can be requested. The project Administrator should be contacted in order for this issue to be
 * solved.
 *
 * @since 1.0.0
 */
public class APIUsageExceededException extends FlybitsException{

    /**
     * Constructs an empty {@code APIUsageExceededException}.
     */
    public APIUsageExceededException(){}

    /**
     * Constructs a new {@code APIUsageExceededException} with a specified message indicating why
     * the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public APIUsageExceededException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code APIUsageExceededException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public APIUsageExceededException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code APIUsageExceededException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public APIUsageExceededException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
