package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.NetworkResponseException;
import com.flybits.commons.library.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DeserializeNetworkError{

    public NetworkResponseException fromJson(String json, int code){
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                JSONObject jObject = new JSONObject(json);
                return fromJson(jObject, code);
            } else if (jsonObject instanceof JSONArray){
                JSONArray jObject = new JSONArray(json);
                return fromJson(jObject, code);
            }else{
                return new NetworkResponseException(code);
            }
        }catch (JSONException | NullPointerException e){}
        return new NetworkResponseException(code);
    }

    public NetworkResponseException fromJson(JSONObject jObj, int code) {

        try {
            if (!jObj.isNull("error")) {
                JSONObject errorObj = jObj.getJSONObject("error");
                Logger.e(errorObj.toString());
                String message = errorObj.getString("exceptionMessage");
                if(!errorObj.isNull("exceptionMessage")){
                    return new NetworkResponseException(code, message);
                }
            }
        }catch (JSONException e){
            Logger.exception("DeserializeNetworkError.fromJson", e);
        }
        return new NetworkResponseException(code);
    }

    public NetworkResponseException fromJson(JSONArray jsonObject, int code) {
        Logger.e(jsonObject.toString());
        return new NetworkResponseException(code, jsonObject.toString());
    }
}
