/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class FlybitsCacheLoader<T> {
    private Context context;
    private Activity activity;
    private AsyncTask task;

    @Deprecated
    protected FlybitsCacheLoader(@NonNull Context context) {
        this.context = context;
    }

    protected FlybitsCacheLoader(@NonNull Activity activity) {
        this.activity = activity;
    }

    public void cancel() {
        if (this.task != null && this.task.getStatus() == AsyncTask.Status.RUNNING) {
            this.task.cancel(true);
        }
    }

    protected Activity getActivity() {
        return this.activity;
    }

    protected Context getContext() {
        if (this.activity != null) {
            return this.activity.getApplicationContext();
        }
        return this.context;
    }

    protected abstract List<T> load(List<String> var1, int var2);

    protected abstract T load(String var1);

    protected void getList(@NonNull String cachingKey, CacheListLoader<T> callback) {
        this.task = this.activity == null ? new GetCachedDataList(callback).execute(new String[]{cachingKey}) : new GetCachedDataList(this.activity, callback).execute(new String[]{cachingKey});
    }

    protected void getList(@NonNull String cachingKey, int limit, CacheListLoader<T> callback) {
        this.task = this.activity == null ? new GetCachedDataList(callback, limit).execute(new String[]{cachingKey}) : new GetCachedDataList(this.activity, callback, limit).execute(new String[]{cachingKey});
    }

    protected void getItem(@Nullable String id, CacheObjectLoader<T> callback) {
        this.task = this.activity == null ? new GetCachedObject(callback).execute(new String[]{id}) : new GetCachedObject(this.activity, callback).execute(new String[]{id});
    }

    private class GetCachedObject
    extends AsyncTask<String, Integer, T> {
        private CacheObjectLoader<T> callback;
        private WeakReference<Activity> mActivityRef;

        protected GetCachedObject(CacheObjectLoader<T> callback) {
            this.callback = callback;
        }

        protected GetCachedObject(Activity activity, CacheObjectLoader<T> callback) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.callback = callback;
        }

        protected T doInBackground(String ... id) {
            return FlybitsCacheLoader.this.load(id[0]);
        }

        protected void onPostExecute(T result) {
            if (this.callback != null) {
                if (this.mActivityRef == null && !this.isCancelled()) {
                    if (result != null) {
                        this.callback.onLoad(result);
                    } else {
                        this.callback.onNotFound();
                    }
                } else if (this.mActivityRef.get() != null) {
                    if (result != null) {
                        this.callback.onLoad(result);
                    } else {
                        this.callback.onNotFound();
                    }
                }
            }
        }
    }

    private class GetCachedDataList
    extends AsyncTask<String, Integer, List<T>> {
        private CacheListLoader<T> callback;
        private WeakReference<Activity> mActivityRef;
        private int limit = -1;

        GetCachedDataList(CacheListLoader<T> callback, int limit) {
            this(callback);
            this.limit = limit;
        }

        GetCachedDataList(CacheListLoader<T> callback) {
            this.callback = callback;
        }

        GetCachedDataList(Activity activity, CacheListLoader<T> callback, int limit) {
            this(callback, limit);
            this.mActivityRef = new WeakReference<Activity>(activity);
        }

        GetCachedDataList(Activity activity, CacheListLoader<T> callback) {
            this.callback = callback;
            this.mActivityRef = new WeakReference<Activity>(activity);
        }

        protected List<T> doInBackground(String ... cachingKeys) {
            List<CachingEntry> listOfCacheObjects = CommonsDatabase.getDatabase(FlybitsCacheLoader.this.getContext()).cachingEntryDAO().getByKey(cachingKeys[0]);
            ArrayList<String> ids = new ArrayList<String>();
            for (CachingEntry entry : listOfCacheObjects) {
                ids.add(entry.getContentId());
            }
            if (this.limit == -1) {
                this.limit = listOfCacheObjects.size();
            }
            return FlybitsCacheLoader.this.load(ids, this.limit);
        }

        protected void onPostExecute(List<T> result) {
            if (this.callback != null) {
                if (this.mActivityRef == null && !this.isCancelled()) {
                    if (result != null) {
                        this.callback.onLoad(result);
                    } else {
                        this.callback.onLoad(new ArrayList());
                    }
                } else if (this.mActivityRef.get() != null) {
                    if (result != null) {
                        this.callback.onLoad(result);
                    } else {
                        this.callback.onLoad(new ArrayList());
                    }
                }
            }
        }
    }

    public static interface CacheObjectLoader<T> {
        public void onLoad(T var1);

        public void onNotFound();
    }

    public static interface CacheListLoader<T> {
        public void onLoad(List<T> var1);
    }
}

