package com.flybits.commons.library.exceptions

/**
 *  The {@code NotFoundException} is thrown when an api call is returned with not found status code.
 *  This means that the specific api call is either wrong or not present for that user and project
 */
class NotFoundException: FlybitsException {
    /**
     * Constructs a new [NotFoundException] with a generic message
     *
     */
    constructor() : super("The object that you are trying to retrieve could not be found.",404)

    /**
     * Constructs a new [NotFoundException] with error code
     *
     * @param errorCode the error code for this exception.
     */
    constructor(errorCode: Int): super("The object that you are trying to retrieve could not be found." , errorCode)
}