package com.flybits.commons.library.exceptions;

/**
 * A class that represents an exception that was thrown by the Flybits SDK indicating that an
 * unexpected behaviour has occurred.
 *
 * @since 1.0.0
 */
public class FlybitsException extends Exception {

    public int errorCode;

    /**
     * Constructs an empty {@code FlybitsException}.
     */
    public FlybitsException(){}

    /**
     * Constructs a new {@code FlybitsException} with a specified message indicating why the
     * exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public FlybitsException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code FlybitsException} with a specified message indicating why the
     * exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public FlybitsException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new {@code FlybitsException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public FlybitsException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code FlybitsException} with the specified detail message and the specified
     * cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public FlybitsException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
