/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.idps.FlybitsIDP;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ConnectionResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.DeserializeProject;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidFlybitsManagerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.Project;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.results.ProjectsResult;
import com.flybits.commons.library.utils.ProjectParameters;
import com.flybits.internal.db.CommonsDatabase;
import devliving.online.securedpreferencestore.DefaultRecoveryHandler;
import devliving.online.securedpreferencestore.RecoveryHandler;
import devliving.online.securedpreferencestore.SecuredPreferenceStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FlybitsManager {
    public static final String AUTHENTICATION_API = "/sso/auth";
    static final String PROJECTS_API = "/kernel/projects";
    static final String DISCONNECT_ENDPOINT = "/sso/auth/logout";
    public static boolean IS_DEBUG = false;
    private Context context;
    private IDP idProvider;
    private Analytics analytics;
    private ArrayList<String> languageCodes;
    private Set<FlybitsScope> listOfScopes;
    private String projectId;
    private SharedElements sharedElements;

    private FlybitsManager(Builder builder) {
        this.listOfScopes = builder.listOfScopes;
        this.context = builder.mContext;
        this.languageCodes = builder.languageCodes;
        this.idProvider = builder.idProvider;
        this.projectId = builder.projectId;
        this.analytics = new Analytics(this.context);
        this.sharedElements = SharedElements.get(this.context);
        try {
            SecuredPreferenceStore.init((Context)this.context, (String)"flybits_con_storage", (String)this.projectId, null, (RecoveryHandler)new DefaultRecoveryHandler());
        }
        catch (Exception e) {
            Logger.exception("FlybitsManager.build()", e);
        }
        this.sharedElements.migrateUnencrypted(this.context.getSharedPreferences("FLYBITS_PREF", 0));
        if (this.languageCodes.size() == 0) {
            this.languageCodes.add("en");
        }
        if (this.projectId != null) {
            this.sharedElements.setProjectID(this.projectId);
        }
    }

    public static void setDebug() {
        IS_DEBUG = true;
    }

    public static void unsetDebug() {
        IS_DEBUG = false;
    }

    @Deprecated
    public BasicResult bindProject(String projectId, BasicResultCallback callback, @NonNull Handler handler) {
        return Project.bindProject(this.context, projectId, callback, handler);
    }

    @Deprecated
    public BasicResult bindProject(String projectId, BasicResultCallback callback) {
        return Project.bindProject(this.context, projectId, callback);
    }

    public BasicResult connect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.connect(callback, true, handler);
    }

    public BasicResult connect(BasicResultCallback callback) {
        return this.connect(callback, true);
    }

    public BasicResult connect(IDP idp, BasicResultCallback callback, boolean autoUseManifestProject) {
        this.idProvider = idp;
        return this.connect(callback, autoUseManifestProject);
    }

    public BasicResult connect(IDP idp, BasicResultCallback callback) {
        this.idProvider = idp;
        return this.connect(callback, true);
    }

    public BasicResult connect(BasicResultCallback callback, final boolean autoUseManifestProject, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FlybitsManager.this.sharedElements.setLocalization(FlybitsManager.this.languageCodes);
                    Result jwtResult = FlyJWT.refreshJWT(FlybitsManager.this.context);
                    if (jwtResult.getStatus() == RequestStatus.COMPLETED) {
                        query.setResult(jwtResult);
                    } else if (FlybitsManager.this.idProvider != null) {
                        String body2 = FlybitsManager.this.idProvider.getRequestBody(FlybitsManager.this.context, autoUseManifestProject).toString();
                        String url = FlybitsManager.AUTHENTICATION_API + FlybitsManager.this.idProvider.getAuthenticationEndPoint();
                        Result<User> authenticatedUser = FlyAway.post(FlybitsManager.this.context, url, body2, (IDeserializer)new DeserializeLogin(), "FlybitsManager.connect", User.class);
                        if (authenticatedUser.getStatus() == RequestStatus.COMPLETED) {
                            if (FlybitsManager.this.idProvider instanceof FlybitsIDP && ((FlybitsIDP)FlybitsManager.this.idProvider).isSendConfirmationEmail()) {
                                FlybitsIDP.sendConfirmationEmail(FlybitsManager.this.context, ((FlybitsIDP)FlybitsManager.this.idProvider).getEmail(), null);
                            }
                            CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao().insert(authenticatedUser.getResult());
                            FlybitsManager.this.sharedElements.setConnectedIDP(FlybitsManager.this.idProvider.getProvider());
                            FlybitsManager.this.analytics.scheduleWorkers();
                            for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                                scope.onConnected(FlybitsManager.this.context, authenticatedUser.getResult());
                            }
                        }
                        query.setResult(authenticatedUser);
                    }
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public BasicResult connect(BasicResultCallback callback, boolean autoUseManifestProject) {
        return this.connect(callback, autoUseManifestProject, new Handler(Looper.getMainLooper()));
    }

    public BasicResult destroy(BasicResultCallback callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FlybitsManager.this.analytics.flush(null, false);
                    String jwtToken = FlybitsManager.this.sharedElements.getSavedJWTToken();
                    Result deleteUser = FlyAway.delete(FlybitsManager.this.context, "/sso/auth/me", "FlybitsManager.destroy", null);
                    if (deleteUser.getStatus() == RequestStatus.COMPLETED) {
                        FlybitsManager.this.clearSDKData(FlybitsManager.this.context);
                        for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                            scope.onAccountDestroyed(FlybitsManager.this.context, jwtToken);
                        }
                    }
                    request.setResult(deleteUser);
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public BasicResult destroy(BasicResultCallback callback) {
        return this.destroy(callback, new Handler(Looper.getMainLooper()));
    }

    public BasicResult disconnect(BasicResultCallback callback) {
        return this.disconnect(callback, false);
    }

    public BasicResult disconnect(BasicResultCallback callback, final boolean disconnectOnException, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                String jwtToken = FlybitsManager.this.sharedElements.getSavedJWTToken();
                try {
                    FlybitsManager.this.analytics.flush(null, false);
                    Result disconnected = FlyAway.post(FlybitsManager.this.context, FlybitsManager.DISCONNECT_ENDPOINT, "", null, "FlybitsManager.disconnect", null);
                    if (disconnected.getStatus() == RequestStatus.COMPLETED || disconnectOnException) {
                        FlybitsManager.this.clearSDKData(FlybitsManager.this.context);
                        for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                            scope.onDisconnected(FlybitsManager.this.context, jwtToken);
                        }
                        request.setResult(new Result(200, ""));
                    } else {
                        request.setResult(disconnected);
                    }
                }
                catch (FlybitsException e) {
                    if (disconnectOnException) {
                        FlybitsManager.this.clearSDKData(FlybitsManager.this.context);
                        for (FlybitsScope scope : FlybitsManager.this.listOfScopes) {
                            scope.onDisconnected(FlybitsManager.this.context, jwtToken);
                        }
                    }
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public BasicResult disconnect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.disconnect(callback, false, handler);
    }

    public BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException) {
        return this.disconnect(callback, disconnectOnException, new Handler(Looper.getMainLooper()));
    }

    public ProjectsResult getProjects(final ProjectParameters params, PagedResultCallback<Project> callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ProjectsResult result = new ProjectsResult(this.context, params, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isConnnected;
                    boolean bl = isConnnected = !FlybitsManager.this.sharedElements.getSavedJWTToken().equals("");
                    if (!isConnnected || !(FlybitsManager.this.getIDP() instanceof FlybitsIDP)) {
                        throw new FlybitsException("Either not yet connected to Flybits, or you are not using the Flybits IDP. GetProjects() only works with the Flybits IDP.");
                    }
                    DeserializeProject singleDeserializaer = new DeserializeProject();
                    DeserializePagedResponse deserializer = new DeserializePagedResponse(singleDeserializaer);
                    Result projectList = FlyAway.get(FlybitsManager.this.context, FlybitsManager.PROJECTS_API, params, deserializer, "FlybitsManager.getProjects");
                    result.setResult(projectList, params);
                }
                catch (FlybitsException e) {
                    result.setFailed(e);
                }
            }
        });
        return result;
    }

    public ProjectsResult getProjects(ProjectParameters params, PagedResultCallback<Project> callback) {
        return this.getProjects(params, callback, new Handler(Looper.getMainLooper()));
    }

    @Deprecated
    public static ObjectResult<User> getUser(Context context) {
        return User.getSelf(context, null);
    }

    @Deprecated
    public static ObjectResult<User> getUser(Context context, ObjectResultCallback<User> callback, @NonNull Handler handler) {
        return User.getSelf(context, callback, handler);
    }

    @Deprecated
    public static ObjectResult<User> getUser(Context context, ObjectResultCallback<User> callback) {
        return User.getSelf(context, callback);
    }

    public static ConnectionResult isConnected(final @NonNull Context context, final boolean confirmThroughNetwork, final @NonNull ConnectionResultCallback callback, final @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ConnectionResult query = new ConnectionResult(callback, handler, executorService);
        final SharedElements sharedElements = SharedElements.get(context);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (confirmThroughNetwork && !sharedElements.getSavedJWTToken().equals("")) {
                    try {
                        final Result getJWT = FlyJWT.refreshJWT(context);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (getJWT.getStatus() == RequestStatus.NOT_CONNECTED) {
                                    callback.notConnected();
                                } else if (getJWT.getStatus() == RequestStatus.COMPLETED) {
                                    callback.onConnected();
                                } else {
                                    callback.onException(getJWT.getException());
                                }
                            }
                        });
                    }
                    catch (FlybitsException e) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onException(e);
                            }
                        });
                    }
                } else if (sharedElements.getSavedJWTToken().equals("")) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.notConnected();
                        }
                    });
                } else {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnected();
                        }
                    });
                }
            }
        });
        return query;
    }

    public static ConnectionResult isConnected(@NonNull Context context, boolean confirmThroughNetwork, @NonNull ConnectionResultCallback callback) {
        return FlybitsManager.isConnected(context, confirmThroughNetwork, callback, new Handler(Looper.getMainLooper()));
    }

    static void clearUserInformation(Context context) {
        SharedElements.get(context).clear();
    }

    IDP getIDP() {
        return this.idProvider;
    }

    Set<FlybitsScope> getScopes() {
        return this.listOfScopes;
    }

    private void clearSDKData(Context context) {
        this.analytics.destroy();
        FlybitsManager.clearUserInformation(context);
        CommonsDatabase.getDatabase(context).userDao().delete();
        CommonsDatabase.getDatabase(context).cachingEntryDAO().clear();
    }

    public static final class Builder {
        private final Set<FlybitsScope> listOfScopes;
        private Context mContext;
        private IDP idProvider;
        private ArrayList<String> languageCodes;
        private String projectId;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.listOfScopes = new HashSet<FlybitsScope>();
            this.languageCodes = new ArrayList();
            try {
                this.languageCodes.add(Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Builder addScope(@NonNull FlybitsScope scope) {
            this.listOfScopes.add(scope);
            return this;
        }

        public FlybitsManager build() throws InvalidFlybitsManagerException {
            this.checkIfFieldsSet();
            return new FlybitsManager(this);
        }

        public Builder setAccount(IDP idp) {
            this.idProvider = idp;
            return this;
        }

        public Builder setDebug() {
            IS_DEBUG = true;
            return this;
        }

        public Builder setLanguage(@NonNull String languageCode) {
            this.languageCodes.clear();
            this.languageCodes.add(languageCode);
            return this;
        }

        public Builder setProjectId(@NonNull String projectId) {
            this.projectId = projectId;
            return this;
        }

        private void checkIfFieldsSet() throws InvalidFlybitsManagerException {
            if (this.listOfScopes.size() == 0) {
                throw new InvalidFlybitsManagerException("You must have at least 1 scope set to create a valid FlybitsManager object");
            }
            if (this.languageCodes.size() != 1 && this.languageCodes.get(0).length() != 2) {
                throw new InvalidFlybitsManagerException("Your language must be a 2-letter code. Make sure you call setLanguage(String)");
            }
        }
    }
}

