package com.flybits.commons.library.exceptions;

/**
 *  The {@code InvalidRegionException} is thrown if the application attempts to register to a
 *  Flybits server region that is not valid. Currently only "south-america" and "north-america" are
 *  valid entries.
 *
 *  @since 1.0.0
 */
public class InvalidRegionException extends RuntimeException{

    /**
     * Constructs an empty {@code InvalidRegionException}.
     */
    public InvalidRegionException(){}

    /**
     * Constructs a new {@code InvalidRegionException} with a specified message indicating why the
     * exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public InvalidRegionException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code InvalidRegionException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public InvalidRegionException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code InvalidRegionException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public InvalidRegionException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
