package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.NetworkResponseException;
import com.flybits.commons.library.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DeserializeNetworkError extends IDeserializer<NetworkResponseException>{

    @Override
    public String toJson(NetworkResponseException obj) {

        JSONObject object = new JSONObject();
        return object.toString();
    }

    @Override
    public NetworkResponseException fromJson(String json){
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject){
                JSONObject jObject  = new JSONObject(json);
                return fromJson(jObject);
            }else if (jsonObject instanceof JSONArray){
                JSONArray jObject  = new JSONArray(json);
                return fromJson(jObject);
            }else{
                return new NetworkResponseException(json);
            }
        }catch (JSONException | NullPointerException e){}
        return null;
    }

    @Override
    public NetworkResponseException fromJson(JSONObject jObj) {

        try {
            if (!jObj.isNull("error")) {

                JSONObject jObj2 = jObj.getJSONObject("error");
                if (!jObj2.isNull("exceptionType") && !jObj2.isNull("exceptionMessage")) {
                    String type = jObj2.getString("exceptionType");
                    String message = jObj2.getString("exceptionMessage");

                    if (!jObj2.isNull("requestId")) {
                        String requestId = jObj2.getString("requestId");
                        return new NetworkResponseException(message, requestId, type);
                    }
                    return new NetworkResponseException(message, type);
                }
            }
        }catch (JSONException e){
            Logger.exception("DeserializeNetworkError.fromJson", e);
        }
        return null;
    }

    @Override
    public NetworkResponseException fromJson(JSONArray jsonObject) {
        return null;
    }
}
