package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;

/**
 * The {@code SignedIDP} class is responsible for creating the specification for an IDentity Provider
 * (IDP) that can be logged into using the SAML protocol. The {@code SignedIDP} creates a
 * {@link com.flybits.commons.library.models.User} based on the information retrieved from the
 * SAML IDP regardless of where the IDP is hosted.
 */
public class SignedIDP extends IDP{

    private static final String AUTHENTICATE_ENDPOINT       = "/signedLogin";

    private String accessToken;
    private String signature;

    private SignedIDP(Parcel in){
        super(in);
        accessToken = in.readString();
        signature   = in.readString();
    }

    /**
     * Constructor used to register to an identity provider using a signed access token that
     * requires a confirm signiture used to sign the {@code accessToken}.
     *
     * @param accessToken The access token obtained from the 3rd party source.
     * @param signature The access token signature used to validate the access token.
     */
    public SignedIDP(String accessToken, String signature){
        super("signedLogin");
        this.accessToken    = accessToken;
        this.signature      = signature;
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject   = new JSONObject();

        try {
            bodyObject.put("accessToken", accessToken);
        }catch (JSONException e){}
        try {
            bodyObject.put("signature", signature);
        }catch (JSONException e){}

        return bodyObject;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(accessToken);
        out.writeString(signature);
    }

    public static final Parcelable.Creator<SignedIDP> CREATOR = new Creator<SignedIDP>() {
        @Override
        public SignedIDP createFromParcel(Parcel in) {
            return new SignedIDP(in);
        }

        @Override
        public SignedIDP[] newArray(int size) {
            return new SignedIDP[size];
        }
    };

    public static String base64Encode(Context context, String email){

        JSONObject bodyObject   = new JSONObject();

        try {
            bodyObject.put("projectId", getProjectID(context));
        }catch (JSONException e){}
        try {
            bodyObject.put("email", email);
        }catch (JSONException e){}

        try {
            String body = bodyObject.toString();
            byte[] data = body.getBytes("UTF-8");
            return Base64.encodeToString(data, Base64.NO_WRAP);
        }catch (UnsupportedEncodingException ex){
            return null;
        }
    }
}
