/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.commons.library.models.User;
import com.flybits.internal.db.UserDAO;
import java.util.Set;

public class UserDAO_Impl
implements UserDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfUser;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteSingle;

    public UserDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUser = new EntityInsertionAdapter<User>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user`(`deviceID`,`email`,`firstName`,`id`,`lastName`,`isVerified`,`isOptedIn`,`isActive`,`customerID`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getDeviceID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDeviceID());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getFirstName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFirstName());
                }
                if (value.getId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getId());
                }
                if (value.getLastName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getLastName());
                }
                int _tmp = value.isVerified() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                int _tmp_1 = value.isOptedIn() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                int _tmp_2 = value.isActive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                if (value.getCustomerID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCustomerID());
                }
            }
        };
        this.__updateAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user` SET `deviceID` = ?,`email` = ?,`firstName` = ?,`id` = ?,`lastName` = ?,`isVerified` = ?,`isOptedIn` = ?,`isActive` = ?,`customerID` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getDeviceID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDeviceID());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getFirstName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFirstName());
                }
                if (value.getId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getId());
                }
                if (value.getLastName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getLastName());
                }
                int _tmp = value.isVerified() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                int _tmp_1 = value.isOptedIn() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                int _tmp_2 = value.isActive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                if (value.getCustomerID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCustomerID());
                }
                if (value.getId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getId());
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from user";
                return "Delete from user";
            }
        };
        this.__preparedStmtOfDeleteSingle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from user WHERE id IN (?)";
                return "Delete from user WHERE id IN (?)";
            }
        };
    }

    @Override
    public void insert(User plugins) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUser.insert((Object)plugins);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(User plugin) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUser.handle((Object)plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSingle(String id) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteSingle.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (id == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, id);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteSingle.release(_stmt);
        }
    }

    @Override
    public LiveData<User> get() {
        String _sql = "Select * from user LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user LIMIT 1", (int)0);
        return new ComputableLiveData<User>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected User compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("user", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    UserDAO_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = UserDAO_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    User _result;
                    int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
                    int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
                    int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
                    int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
                    int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
                    int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
                    int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
                    if (_cursor.moveToFirst()) {
                        _result = new User();
                        String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                        _result.setDeviceID(_tmpDeviceID);
                        String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                        _result.setEmail(_tmpEmail);
                        String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                        _result.setFirstName(_tmpFirstName);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                        _result.setLastName(_tmpLastName);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                        boolean _tmpIsVerified = _tmp != 0;
                        _result.setIsVerified(_tmpIsVerified);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                        boolean _tmpIsOptedIn = _tmp_1 != 0;
                        _result.setOptedIn(_tmpIsOptedIn);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp_2 != 0;
                        _result.setActive(_tmpIsActive);
                        String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                        _result.setCustomerID(_tmpCustomerID);
                    } else {
                        _result = null;
                    }
                    User user = _result;
                    return user;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingle() {
        String _sql = "Select * from user LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user LIMIT 1", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            User _result;
            int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
            int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
            int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
            int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
            int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
            int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
            int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleById(String id) {
        String _sql = "Select * from user WHERE id IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE id IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            User _result;
            int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
            int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
            int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
            int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
            int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
            int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
            int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getActiveUser() {
        String _sql = "Select * from user WHERE isActive = 1 LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE isActive = 1 LIMIT 1", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            User _result;
            int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
            int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
            int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
            int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
            int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
            int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
            int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleByUserAndCustomerId(String userId, String customerID) {
        String _sql = "Select * from user WHERE customerID IN (?) and id IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE customerID IN (?) and id IN (?) LIMIT 1", (int)2);
        int _argIndex = 1;
        if (customerID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, customerID);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            User _result;
            int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
            int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
            int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
            int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
            int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
            int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
            int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleByCustomerId(String customerID) {
        String _sql = "Select * from user WHERE customerID IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE customerID IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (customerID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, customerID);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            User _result;
            int _cursorIndexOfDeviceID = _cursor.getColumnIndexOrThrow("deviceID");
            int _cursorIndexOfEmail = _cursor.getColumnIndexOrThrow("email");
            int _cursorIndexOfFirstName = _cursor.getColumnIndexOrThrow("firstName");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfLastName = _cursor.getColumnIndexOrThrow("lastName");
            int _cursorIndexOfIsVerified = _cursor.getColumnIndexOrThrow("isVerified");
            int _cursorIndexOfIsOptedIn = _cursor.getColumnIndexOrThrow("isOptedIn");
            int _cursorIndexOfIsActive = _cursor.getColumnIndexOrThrow("isActive");
            int _cursorIndexOfCustomerID = _cursor.getColumnIndexOrThrow("customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

