package com.flybits.commons.library.utils;

import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;

/**
 * The {@link ProjectParameters} class stores any GET parameters that may be requested by the
 * developer. These are then provided to getProjects().
 */
public class ProjectParameters extends QueryParameters {

    private ProjectParameters(Builder builder) {
        super(builder);
    }

    /**
     * The {@link Builder} is used to create {@link ProjectParameters}.
     */
    public static class Builder extends QueryBuilder<Builder> {

        /**
         * Default constructor to initializes all variables.
         */
        public Builder(){
            super();
        }

        /**
         * Instantiates a new {@link ProjectParameters} object using the given options.
         * @return The {@link ProjectParameters} that is used to construct the Query parameters for
         * the network request.
         */
        public ProjectParameters build(){
            return new ProjectParameters(this);
        }
    }
}
