package com.flybits.commons.library.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.Project;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.utils.ProjectParameters;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

/**
 * This class holds the last state of a request when getting {@code Project}s. This allows for pagination
 * state to be used for getting more items.
 */
public class ProjectsResult extends PagedResult<Project> {

    private FlybitsManager manager;

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param parameters {@link ProjectParameters} The parameters that are part of the request.
     * @param callback The callback that was used for the request.
     * @param service The {@code ExecutorService} used for the request.
     */
    public ProjectsResult(Context context, ProjectParameters parameters, PagedResultCallback<Project> callback, ExecutorService service, Handler handler, FlybitsManager manager){
        super(context, parameters, callback, handler, service);
        this.manager = manager;
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K filter, @NotNull PagedResultCallback<Project> callback) {
        manager.getProjects((ProjectParameters) filter, callback);
    }
}
