package com.flybits.commons.library.exceptions;

/**
 * The {@code InvalidProjectIDException} class represents an exception that was thrown when you are
 * attempting to change the Project ID without logging out of a previously logged in user to another
 * project.
 */
public class InvalidProjectIDException extends RuntimeException{

    /**
     * Constructs an empty {@code InvalidProjectIDException}.
     */
    public InvalidProjectIDException(){}

    /**
     * Constructs a new {@code InvalidProjectIDException} with a specified message indicating why
     * the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public InvalidProjectIDException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code InvalidProjectIDException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public InvalidProjectIDException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code InvalidProjectIDException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public InvalidProjectIDException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
