/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.idps.HttpMethod;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidProjectIDException;
import com.flybits.commons.library.exceptions.MissingProjectIDException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class IDP
implements Parcelable {
    private String provider;

    public IDP(String provider) {
        this.provider = provider;
    }

    public IDP(Parcel in) {
        this.provider = in.readString();
    }

    public abstract String getAuthenticationEndPoint();

    public HttpMethod getRequestType() {
        return HttpMethod.POST;
    }

    public HashMap<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    public static String getProjectID(Context mContext) throws MissingProjectIDException {
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(mContext);
        String savedProjectId = sharedElements.getProjectID();
        String projectID = null;
        try {
            ApplicationInfo ai = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.projectID")) {
                projectID = bundle.getString("com.flybits.projectID");
                sharedElements.setProjectID(projectID);
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception("IDP.getProjectID", (Exception)e);
        }
        if ((savedProjectId == null || savedProjectId.length() == 0) && projectID == null) {
            throw new MissingProjectIDException("Your Flybits ProjectID has not been set. Please make sure you set it within the AndroidManifest.xml file under the meta key: 'com.flybits.projectID'");
        }
        if (savedProjectId != null && savedProjectId.length() > 0 && projectID != null && !savedProjectId.equalsIgnoreCase(projectID)) {
            throw new InvalidProjectIDException("It appears you are trying to access Flybits with a different Project ID than the logged in user. Try uninstalling the application correctly and re-running it to login successfully.");
        }
        if (savedProjectId != null && savedProjectId.length() > 0) {
            return savedProjectId;
        }
        return projectID;
    }

    public String getProvider() {
        return this.provider;
    }

    public JSONObject getRequestBody(Context context) throws MissingProjectIDException, FlybitsException {
        return this.getRequestBody(context, true);
    }

    public JSONObject getRequestBody(Context mContext, boolean autoUseProjectId) throws MissingProjectIDException, FlybitsException {
        JSONObject bodyObject = this.getBody();
        if (bodyObject == null) {
            bodyObject = new JSONObject();
        }
        if (!autoUseProjectId) {
            return bodyObject;
        }
        try {
            bodyObject.put("projectId", (Object)IDP.getProjectID(mContext));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bodyObject;
    }

    public abstract JSONObject getBody() throws FlybitsException;

    public void onAuthenticated(Context context, @NotNull User user) {
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.provider);
    }
}

