/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.OptInStateObservable;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="user")
public class User
implements Parcelable {
    public static final String FIELD_IS_OPTED_IN = "isOptedIn";
    public static final String ME_ENDPOINT = "/sso/auth/me";
    @ColumnInfo(name="deviceID")
    private String deviceID;
    @ColumnInfo(name="email")
    private String email;
    @ColumnInfo(name="firstName")
    private String firstName;
    @PrimaryKey
    @ColumnInfo(name="id")
    @NonNull
    private String id;
    @ColumnInfo(name="lastName")
    private String lastName;
    @ColumnInfo(name="isVerified")
    private boolean isVerified;
    @ColumnInfo(name="isOptedIn")
    private boolean isOptedIn;
    public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel in) {
            return new User(in);
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };

    public User() {
    }

    @Ignore
    public User(Parcel in) {
        this.id = in.readString();
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.email = in.readString();
        this.deviceID = in.readString();
        this.isVerified = in.readInt() == 1;
        this.isOptedIn = in.readInt() == 1;
    }

    @Ignore
    public User(@NonNull String id, @NonNull String email, @NonNull String deviceID) {
        this.deviceID = deviceID;
        this.email = email;
        this.id = id;
    }

    @Ignore
    public User(@NonNull User user) {
        this.deviceID = user.deviceID;
        this.email = user.email;
        this.id = user.id;
        this.firstName = user.firstName;
        this.lastName = user.lastName;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public boolean isOptedIn() {
        return this.isOptedIn;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIsVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setName(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public void setOptedIn(boolean isOptedIn) {
        this.isOptedIn = isOptedIn;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User another = (User)o;
        return another.id.equals(this.id);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.id);
        out.writeString(this.firstName);
        out.writeString(this.lastName);
        out.writeString(this.email);
        out.writeString(this.deviceID);
        out.writeInt(this.isVerified ? 1 : 0);
        out.writeInt(this.isOptedIn ? 1 : 0);
    }

    public static ObjectResult<User> getSelf(Context context) {
        return User.getSelf(context, null);
    }

    public static ObjectResult<User> getSelf(final Context context, ObjectResultCallback<User> callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<User> request = new ObjectResult<User>(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result<User> getUser = FlyAway.get(context, User.ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                    if (getUser.getStatus() == RequestStatus.COMPLETED) {
                        User user = getUser.getResult();
                        CommonsDatabase.getDatabase(context).userDao().update(user);
                        OptInStateObservable.INSTANCE.broadcastOptInState(user.isOptedIn, null);
                    }
                    request.setResult(getUser);
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public static ObjectResult<User> getSelf(Context context, ObjectResultCallback<User> callback) {
        return User.getSelf(context, callback, new Handler(Looper.getMainLooper()));
    }
}

