package com.flybits.commons.library.logging


import android.util.Log

import com.flybits.commons.library.api.FlybitsManager.IS_DEBUG

/**
 * The [Displayer] class is used to display information within the logcat.
 */
class Displayer internal constructor(var tag: String) {

    /**
     * Change the tag for which the information is logged under within the logcat.
     *
     * @param tag The `tag` to set for information to be displayed under.
     * @return The [Displayer] class that is used to display information within the logcat.
     */
    fun changeTag(tag: String): Displayer {
        this.tag = tag
        return this
    }

    /**
     * Creates a log statement in the logcat that displays information used to debug the Flybits
     * SDK.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    fun d(msg: String) {
        if (IS_DEBUG) {
            Log.d(tag, msg)
        }
    }

    /**
     * Creates a log statement in the logcat that displays an error.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    fun e(msg: String) {
        if (IS_DEBUG) {
            Log.e(tag, msg)
        }
    }

    /**
     * Creates a log statement in the logcat that displays some information.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    fun i(msg: String) {
        if (IS_DEBUG) {
            Log.i(tag, msg)
        }
    }

    /**
     * Creates a log statement in the logcat that displays a warning.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    fun w(msg: String) {
        if (IS_DEBUG) {
            Log.w(tag, msg)
        }
    }

    internal fun exception(e: Exception) {
        if (IS_DEBUG) {
            e.printStackTrace()
        }
    }
}
