package com.flybits.concierge.smartrewards.useractionhandlers

import android.os.Bundle
import android.os.Parcel
import android.os.Parcelable
import android.support.design.widget.Snackbar
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.ResourceProvider
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.activities.OfferActivity
import com.flybits.concierge.smartrewards.model.Offer
import com.flybits.concierge.smartrewards.model.Offers
import java.lang.IllegalArgumentException

/**
 * Responsible for handling user actions for the [Offers] content type.
 *
 * Implementation of [Parcelable] interface is left up to the child class on purpose
 * that way it isn't overlooked during its implementation.
 *
 * @param resourceProvider Retrieves Android resources. Leaving null may cause string localization to not work correctly.
 */
open class OfferUserActionHandler(private val resourceProvider: ResourceProvider? = null) : UserActionHandler<Offer> {

    constructor(parcel: Parcel) : this()

    override fun writeToParcel(parcel: Parcel, flags: Int) {
    }

    override fun describeContents(): Int {
        return 0
    }

    override fun onUserAction(action: Int, data: Offer, flybitsNavigator: FlybitsNavigator) {
        when(action) {
            TAPPED_TILE -> {
                val bundle = Bundle()
                bundle.putParcelable(OfferActivity.EXTRA_OFFER_DETAILS, data)
                bundle.putParcelable(OfferActivity.EXTRA_USER_ACTION_HANDLER, this)
                flybitsNavigator.openActivity(OfferActivity::class.java, bundle)
            }
            TAPPED_PRIMARY_BUTTON -> {
                data.primaryButton?.actionURL?.let {
                    val success = flybitsNavigator.openUrl(it)
                    if (!success) {
                        val message = resourceProvider?.getString(R.string.flybits_con_generic_error)
                        flybitsNavigator.openSnackbar(message ?: "An error occurred while loading. Check your internet connection.", Snackbar.LENGTH_SHORT)
                    }
                }
            }
            TAPPED_SECONDARY_BUTTON -> {
                data.secondaryButton?.actionURL?.let {
                    if (it.isEmpty()){
                        //Close activity if URL is empty
                        flybitsNavigator.dismiss()
                    } else {
                        flybitsNavigator.openUrl(it)
                    }
                }

            }
            else -> throw IllegalArgumentException("Invalid action, action = $action")
        }
    }

    companion object {
        const val TAPPED_TILE = 0
        const val TAPPED_PRIMARY_BUTTON = 1
        const val TAPPED_SECONDARY_BUTTON = 2

        @JvmField
        val CREATOR = object : Parcelable.Creator<OfferUserActionHandler> {
            override fun createFromParcel(parcel: Parcel): OfferUserActionHandler {
                return OfferUserActionHandler(parcel)
            }

            override fun newArray(size: Int): Array<OfferUserActionHandler?> {
                return arrayOfNulls(size)
            }
        }
    }

}