package com.flybits.concierge.smartrewards.model;

import android.os.Parcel;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class Offer extends BaseTemplate {

    public String banner;
    public LocalizedValue header;
    public LocalizedValue title;
    public LocalizedValue subtitle;
    public ActionButton primaryButton;
    public ActionButton secondaryButton;
    public LocalizedValue explanation;

    public Offer() {

    }

    public Offer(Parcel in) {
        super(in);
        banner = in.readString();
        header = in.readParcelable(LocalizedValue.class.getClassLoader());
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        subtitle = in.readParcelable(LocalizedValue.class.getClassLoader());
        primaryButton = in.readParcelable(SimpleButton.class.getClassLoader());
        secondaryButton = in.readParcelable(SimpleButton.class.getClassLoader());
        explanation = in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(banner);
        dest.writeParcelable(header, flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(subtitle, flags);
        dest.writeParcelable(primaryButton, flags);
        dest.writeParcelable(secondaryButton, flags);
        dest.writeParcelable(explanation, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Offer> CREATOR = new Creator<Offer>() {
        @Override
        public Offer createFromParcel(Parcel in)
        {
            return new Offer(in);
        }

        @Override
        public Offer[] newArray(int size)
        {
            return new Offer[size];
        }
    };
}
