package com.flybits.concierge.smartrewards.viewproviders

import android.support.v4.view.PagerAdapter
import android.support.v4.view.ViewPager
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.fragments.OfferFragment
import com.flybits.concierge.smartrewards.model.Offer
import com.flybits.concierge.smartrewards.model.Offers
import com.flybits.concierge.viewholders.FlybitsViewHolder

class OffersViewProvider : FlybitsViewProvider <Offers> {
    override fun getClassType(): Class<Offers> {
        return Offers::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-offers-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Offers> {
        return OffersViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_offers, parent, false))
    }

    override fun onPushOpened(model: Offers, flybitsNavigator: FlybitsNavigator) {

    }

    companion object {
        private fun configureView(data: Offer, offerView: View, flybitsNavigator: FlybitsNavigator) {
            val bannerView : ImageView = offerView.findViewById(R.id.smartrewards_item_template_offer_banner)
            val headerView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_header)
            val titleView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_title)
            val subtitleView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_subtitle)

            if (!TextUtils.isEmpty(data.banner)) { // banner is optional
                Glide.with(bannerView.context).load(data.banner).apply(RequestOptions().centerCrop()).into(bannerView)
            } else {
                bannerView.setImageResource(android.R.drawable.ic_menu_gallery)
            }

            headerView.text = data.header.value
            titleView.text = data.title.value
            subtitleView.text = data.subtitle.value

            offerView.setOnClickListener {
                flybitsNavigator.openFragment(OfferFragment.newInstance(data))
            }
        }
    }

    class OffersViewHolder(val view: View) : FlybitsViewHolder<Offers>(view) {
        private val pager : ViewPager = view.findViewById(R.id.smartrewards_item_template_offers_viewPager)
        private val single : View = view.findViewById(R.id.smartrewards_item_template_offers_single)
        private val emptyView : View = view.findViewById(R.id.smartrewards_item_template_offers_emptyTxt)

        override fun bindData(data: Offers, flybitsNavigator: FlybitsNavigator) {
            pager.visibility = View.GONE
            single.visibility = View.GONE
            emptyView.visibility = View.GONE

            when (data.offers.size) {
                0 -> {
                    emptyView.visibility = View.VISIBLE
                }
                1 -> {
                    single.visibility = View.VISIBLE
                    configureView(data.offers[0], view, flybitsNavigator)
                }
                else -> {
                    pager.visibility = View.VISIBLE
                    val adapter = OfferAdapter(data.offers, flybitsNavigator)

                    pager.clipToPadding = false
                    pager.setPadding(50, 0, 50, 0)
                    pager.pageMargin = 5

                    pager.adapter = adapter
                }
            }
        }
    }

    class OfferAdapter(private val offers : List<Offer>, private val flybitsNavigator: FlybitsNavigator) : PagerAdapter () {
        override fun instantiateItem(container: ViewGroup, position: Int): Any {
            val itemView : View = LayoutInflater.from(container.context).inflate(R.layout.smartrewards_item_template_offer, container, false)
            container.addView(itemView)

            configureView(offers[position], itemView, flybitsNavigator)

            return itemView
        }

        override fun isViewFromObject(p0: View, p1: Any): Boolean {
            return p0 == p1
        }

        override fun getCount(): Int {
            return offers.size
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }
    }
}