package com.flybits.concierge.smartrewards.viewproviders

import android.content.Intent
import android.net.Uri
import android.support.v4.view.PagerAdapter
import android.support.v4.view.ViewPager
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.model.Benefit
import com.flybits.concierge.smartrewards.model.Benefits
import com.flybits.concierge.viewholders.FlybitsViewHolder


class BenefitsViewProvider : FlybitsViewProvider <Benefits> {
    override fun getClassType(): Class<Benefits> {
        return Benefits::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-benefits-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Benefits> {
        return BenefitsViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_benefits, parent, false))
    }

    override fun onPushOpened(model: Benefits, flybitsNavigator: FlybitsNavigator) {

    }

    companion object {
        private fun configureView(data: Benefit, benefitView: View) {
            val gradientView: View = benefitView.findViewById(R.id.smartrewards_benefit_gradient)
            val headerTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_header)
            val titleTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_title)
            val descriptionTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_description)
            val sourceTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_source)
            val sourceImageView: ImageView = benefitView.findViewById(R.id.smartrewards_benefit_sourceImg)
            val primaryButton: TextView = benefitView.findViewById(R.id.smartrewards_benefit_primaryBtn)

            gradientView.background = data.gradientDrawable

            if (!TextUtils.isEmpty(data.header)) {
                headerTextView.visibility = View.VISIBLE
                headerTextView.text = data.header
            } else {
                headerTextView.visibility = View.GONE
            }

            titleTextView.text = data.title.value // required

            descriptionTextView.text = data.explanation.value

            primaryButton.visibility = View.INVISIBLE
            if (data.primaryButton != null
                && data.primaryButton.label != null
                && !TextUtils.isEmpty(data.primaryButton.label.value)
                && !TextUtils.isEmpty(data.primaryButton.actionURL)) {
                primaryButton.visibility = View.VISIBLE

                primaryButton.text = data.primaryButton.label.value
                primaryButton.setTextColor(data.primaryButton.getColor())
                data.primaryButton.backgroundDrawable?.let {
                    primaryButton.background = it
                }

                primaryButton.setOnClickListener {
                    val intent = Intent(Intent.ACTION_VIEW)
                    intent.data = Uri.parse(data.primaryButton.actionURL)
                    benefitView.context.startActivity(intent)
                }
            }

            sourceTextView.text = data.source

            if (!TextUtils.isEmpty(data.sourceImage)) {
                sourceImageView.visibility = View.VISIBLE
                Glide.with(sourceImageView.context)
                    .load(data.sourceImage)
                    .into(sourceImageView)
            } else {
                sourceImageView.visibility = View.GONE
            }
        }
    }

    // View Holder for the Benefit Card
    class BenefitsViewHolder (val view: View) : FlybitsViewHolder<Benefits>(view) {

        private val pager : ViewPager = view.findViewById(R.id.smartrewards_item_template_benefits_viewPager)
        private val single : View = view.findViewById(R.id.smartrewards_item_template_benefits_single)
        private val emptyView : View = view.findViewById(R.id.smartrewards_item_template_benefits_emptyTxt)

        override fun bindData(data: Benefits, flybitsNavigator: FlybitsNavigator) {

            pager.visibility = View.GONE
            single.visibility = View.GONE
            emptyView.visibility = View.GONE

            when (data.benefits.size) {
                0 -> {
                    emptyView.visibility = View.VISIBLE
                }
                1 -> { // single view
                    single.visibility = View.VISIBLE
                    configureView(data.benefits[0], view)
                }
                else -> { // multi view
                    pager.visibility = View.VISIBLE
                    val adapter = BenefitAdapter(data.benefits)

                    pager.clipToPadding = false
                    pager.setPadding(50, 0, 50, 0)
                    pager.pageMargin = 5

                    pager.adapter = adapter
                }
            }
        }
    }

    class BenefitAdapter(val benefits: List<Benefit>): PagerAdapter() {


        override fun instantiateItem(container: ViewGroup, position: Int): Any {

            val itemView : View = LayoutInflater.from(container.context).inflate(R.layout.smartrewards_item_template_benefit, container, false)

            container.addView(itemView)

            configureView(benefits[position], itemView)

            return itemView;
        }

        override fun isViewFromObject(p0: View, p1: Any): Boolean {
            return p0 == p1
        }

        override fun getCount(): Int {
            return benefits.size
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }
    }
}