/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.SystemExecutor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemExecutorLocal
implements SystemExecutor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String catFile(String file) throws Exception {
        byte[] bytes = Files.readAllBytes(Paths.get(file, new String[0]));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public String execProcess(List<Integer> exitValues, String ... command) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        if (this.log.isTraceEnabled()) {
            String cmd = String.join((CharSequence)" ", command);
            this.log.trace("Executing command: {}", (Object)cmd);
        }
        Process process = pb.start();
        process.getOutputStream().close();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Thread outputThread = new Thread(() -> {
            try (InputStream input = process.getInputStream();){
                int n;
                byte[] buffer = new byte[4096];
                while ((n = input.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        outputThread.start();
        int exitCode = process.waitFor();
        outputThread.join();
        if (exitValues != null && !exitValues.isEmpty() && !exitValues.contains(exitCode)) {
            throw new Exception("Unexpected exit code " + exitCode);
        }
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }
}

