/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.SystemExecutor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacDscl {
    private static final Logger log = LoggerFactory.getLogger(MacDscl.class);
    private Path homeDir;
    private Path shell;
    private String realName;
    private Integer uniqueId;
    private Integer primaryGroupId;

    public Path getHomeDir() {
        return this.homeDir;
    }

    public Path getShell() {
        return this.shell;
    }

    public String getRealName() {
        return this.realName;
    }

    public Integer getUniqueId() {
        return this.uniqueId;
    }

    public Integer getPrimaryGroupId() {
        return this.primaryGroupId;
    }

    public static MacDscl readByUser(String user) throws Exception {
        Path usersDir = Paths.get("/Users", new String[0]);
        if (!Files.exists(usersDir, new LinkOption[0])) {
            log.warn("{} was expected to exist, but is missing, unable to lookup user {}", (Object)usersDir, (Object)user);
            return null;
        }
        Path homeDir = usersDir.resolve(user);
        if (!Files.exists(homeDir, new LinkOption[0])) {
            log.warn("Home directory {} was not found for user {}", (Object)homeDir, (Object)user);
            return null;
        }
        return MacDscl.readByHomeDirectory(homeDir);
    }

    public static MacDscl readByHomeDirectory(Path homeDir) throws Exception {
        return MacDscl.readByHomeDirectory(homeDir, SystemExecutor.LOCAL);
    }

    public static MacDscl readByHomeDirectory(Path homeDir, SystemExecutor systemExecutor) throws Exception {
        String output = systemExecutor.execProcess("dscl", ".", "-read", homeDir.toString(), "NFSHomeDirectory", "UserShell", "RealName", "UniqueID", "PrimaryGroupID");
        return MacDscl.parse(output);
    }

    public static MacDscl parse(String content) {
        MacDscl v = new MacDscl();
        int pos = 0;
        int nextNewlinePos = content.indexOf(10, pos);
        while (nextNewlinePos >= 0 || pos < content.length()) {
            int lineEndPos = nextNewlinePos >= 0 ? nextNewlinePos : content.length();
            String line = content.substring(pos, lineEndPos);
            if (line.startsWith("UserShell:")) {
                v.shell = Paths.get(line.substring(10).trim(), new String[0]);
            } else if (line.startsWith("NFSHomeDirectory:")) {
                v.homeDir = Paths.get(line.substring(17).trim(), new String[0]);
            } else if (line.startsWith("UniqueID:")) {
                v.uniqueId = Integer.valueOf(line.substring(9).trim());
            } else if (line.startsWith("PrimaryGroupID:")) {
                v.primaryGroupId = Integer.valueOf(line.substring(15).trim());
            } else if (line.startsWith("RealName:")) {
                String maybeRealName = line.substring(9).trim();
                if (!maybeRealName.trim().isEmpty()) {
                    v.realName = maybeRealName;
                } else {
                    int _nextNewLinePos = content.indexOf(10, nextNewlinePos + 1);
                    if (_nextNewLinePos > 0) {
                        v.realName = content.substring(nextNewlinePos + 1, _nextNewLinePos).trim();
                    }
                }
            }
            pos = lineEndPos + 1;
            nextNewlinePos = content.indexOf(10, pos);
        }
        return v;
    }
}

