/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.ByteRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String readFileToString(Path file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("File not found: " + file);
        }
        byte[] bytes = Files.readAllBytes(file);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String trimToNull(String value) {
        if (value != null && (value = value.trim()).equals("")) {
            return null;
        }
        return value;
    }

    public static Path which(String nameOfExeOrBin) {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] paths;
            for (String p : paths = path.split(File.pathSeparator)) {
                Path pathDir = Paths.get(p, new String[0]);
                Path exeFile = pathDir.resolve(nameOfExeOrBin);
                if (!Files.exists(exeFile, new LinkOption[0])) continue;
                return exeFile;
            }
        }
        return null;
    }

    public static String execAndGetOutput(List<String> commands) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(commands.toArray(new String[0]));
        Process process = processBuilder.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
        }
        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        var5_6 = null;
        try {
            while ((line = reader.readLine()) != null) {
                System.err.println(line);
            }
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var5_6 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException("Process exited with a non-zero code (actual " + exitCode + ")");
        }
        return output.toString();
    }

    public static boolean searchEnvVar(String name, String value) {
        return Utils.searchEnvVar(System.getenv(), name, value);
    }

    public static boolean searchEnvVar(Map<String, String> env, String name, String value) {
        String currentEnvVar = Utils.trimToNull(env.get(name));
        return currentEnvVar != null && currentEnvVar.equals(value);
    }

    public static boolean searchEnvPath(Path path) {
        return Utils.searchEnvPath(System.getenv(), path);
    }

    public static boolean searchEnvPath(Map<String, String> env, Path path) {
        return Utils.searchEnvPath(Utils.trimToNull(env.get("PATH")), path);
    }

    public static boolean searchEnvPath(String pathValueInEnv, Path path) {
        String[] currentPathVarParts;
        for (String currentPathVarPart : currentPathVarParts = pathValueInEnv != null ? pathValueInEnv.split(File.pathSeparator) : new String[]{}) {
            if (currentPathVarPart == null || !currentPathVarPart.equalsIgnoreCase(path.toString())) continue;
            return true;
        }
        return false;
    }

    public static String joinIfDelimiterMissing(String v1, String v2, String delimiter) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1.endsWith(delimiter)) {
            return v1 + v2;
        }
        return v1 + delimiter + v2;
    }

    public static List<String> filterLinesIfPresentInFile(Path file, List<String> lines) throws IOException {
        if (lines == null) {
            return new ArrayList<String>();
        }
        if (lines.isEmpty() || file == null || !Files.exists(file, new LinkOption[0])) {
            return new ArrayList<String>(lines);
        }
        HashSet<String> linesInList = new HashSet<String>(lines);
        HashSet linesToRemove = new HashSet();
        try (Stream<String> fileStream = Files.lines(file, StandardCharsets.UTF_8);){
            fileStream.forEach(fileLine -> {
                if (linesInList.contains(fileLine)) {
                    linesToRemove.add(fileLine);
                }
            });
        }
        return lines.stream().filter(line -> !linesToRemove.contains(line)).collect(Collectors.toList());
    }

    public static void writeLinesToFileWithSectionBeginAndEndLines(Path file, List<String> lines, boolean appendOrReplace) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (!appendOrReplace) {
            for (String line : lines) {
                sb.append(line).append("\n");
            }
            Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            if (lines == null || lines.size() <= 0) {
                throw new IllegalArgumentException("Lines cannot be null or empty.");
            }
            String firstLine = lines.get(0);
            String lastLine = lines.get(lines.size() - 1);
            if (!firstLine.contains(" begin ")) {
                throw new IllegalArgumentException("First line must be a section begin line (was " + firstLine + ")");
            }
            if (!lastLine.contains(" end ")) {
                throw new IllegalArgumentException("Last line must be a section end line (was " + lastLine + ")");
            }
            ByteRange firstLineByteRange = Utils.findLineByteRange(file, firstLine, 0L);
            long nextLineSearchIndex = firstLineByteRange != null ? firstLineByteRange.getIndex() + firstLineByteRange.getLength() : 0L;
            ByteRange lastLineByteRange = Utils.findLineByteRange(file, lastLine, nextLineSearchIndex);
            if (firstLineByteRange != null && lastLineByteRange != null) {
                for (String line : lines) {
                    sb.append(line).append("\n");
                }
                Utils.replaceByteRange(file, sb.toString(), firstLineByteRange.getIndex(), lastLineByteRange.getIndex() + lastLineByteRange.getLength());
            } else {
                int newlinesNeededCount = Utils.newlinesNeededForAppending(file);
                for (int i = 0; i < newlinesNeededCount; ++i) {
                    sb.append("\n");
                }
                for (String line : lines) {
                    sb.append(line).append("\n");
                }
                Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        }
    }

    public static void replaceByteRange(Path file, String content, long replaceStartPos, long replaceEndPos) throws IOException {
        byte[] messageBytes = content.getBytes(StandardCharsets.UTF_8);
        long fileSize = Files.size(file);
        if (replaceStartPos < 0L || replaceEndPos < 0L || replaceStartPos > replaceEndPos || replaceStartPos > fileSize || replaceEndPos > fileSize) {
            throw new IllegalArgumentException(String.format("Invalid startPos (%d) or endPos (%d) for file size (%d).", replaceStartPos, replaceEndPos, fileSize));
        }
        Path tempFile = Files.createTempFile(file.getFileName().toString(), ".tmp", new FileAttribute[0]);
        Utils.replicateFilePermissions(file, tempFile);
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");
             OutputStream os = Files.newOutputStream(tempFile, StandardOpenOption.WRITE);){
            int bytesToRead;
            int bytesRead;
            byte[] buffer = new byte[8192];
            for (long bytesRemaining = replaceStartPos; bytesRemaining > 0L && (bytesRead = raf.read(buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, bytesRemaining))) >= 0; bytesRemaining -= (long)bytesRead) {
                os.write(buffer, 0, bytesRead);
            }
            os.write(messageBytes);
            raf.seek(replaceEndPos);
            while ((bytesRead = raf.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(tempFile);
            throw e;
        }
        try {
            Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * Exception decompiling
     */
    public static ByteRange findLineByteRange(Path filePath, String targetLine, long startPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 38[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeLinesToFile(Path file, List<String> lines, boolean append) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (append && !lines.isEmpty() && Files.exists(file, new LinkOption[0])) {
            int newlinesNeededCount = Utils.newlinesNeededForAppending(file);
            for (int i = 0; i < newlinesNeededCount; ++i) {
                sb.append("\n");
            }
        }
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        if (append) {
            Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        } else {
            Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static int newlinesNeededForAppending(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return 0;
        }
        StringBuilder currentLine = new StringBuilder();
        int lineCount = 0;
        boolean wasLastLine2Empty = false;
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            int charCode;
            while ((charCode = reader.read()) != -1) {
                char c = (char)charCode;
                currentLine.append(c);
                if (c != '\n') continue;
                ++lineCount;
                wasLastLine2Empty = currentLine.toString().trim().length() == 0;
                currentLine.setLength(0);
            }
        }
        String lastLine = currentLine.toString();
        if (lastLine.length() == 0) {
            if (lineCount == 0) {
                return 0;
            }
            if (wasLastLine2Empty) {
                return 0;
            }
            return 1;
        }
        if (lastLine.trim().length() == 0) {
            return 1;
        }
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean endsWithNewlineForAppending(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        long fileSize = Files.size(path);
        if (fileSize == 0L) {
            return true;
        }
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
            raf.seek(fileSize - 1L);
            int lastByte = raf.read();
            boolean bl = lastByte == 10;
            return bl;
        }
        catch (IOException e) {
            throw new IOException("Error accessing file to check newline status: " + path, e);
        }
    }

    public static void replicateFilePermissions(Path sourceFile, Path targetFile) throws IOException {
        Set<String> supportedViews = sourceFile.getFileSystem().supportedFileAttributeViews();
        if (supportedViews.contains("posix")) {
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(sourceFile, new LinkOption[0]);
                Files.setPosixFilePermissions(targetFile, permissions);
            }
            catch (IOException e) {
                log.error("Failed to apply POSIX permissions: " + e.getMessage());
            }
            return;
        }
        if (supportedViews.contains("acl")) {
            try {
                AclFileAttributeView aclView = Files.getFileAttributeView(sourceFile, AclFileAttributeView.class, new LinkOption[0]);
                List<AclEntry> aclEntries = aclView.getAcl();
                AclFileAttributeView targetAclView = Files.getFileAttributeView(targetFile, AclFileAttributeView.class, new LinkOption[0]);
                targetAclView.setAcl(aclEntries);
            }
            catch (IOException e) {
                log.error("Failed to apply ACL permissions: " + e.getMessage());
            }
            return;
        }
        if (supportedViews.contains("dos")) {
            try {
                DosFileAttributeView sourceDos = Files.getFileAttributeView(sourceFile, DosFileAttributeView.class, new LinkOption[0]);
                DosFileAttributes sourceAttrs = sourceDos.readAttributes();
                DosFileAttributeView targetDos = Files.getFileAttributeView(targetFile, DosFileAttributeView.class, new LinkOption[0]);
                targetDos.setReadOnly(sourceAttrs.isReadOnly());
                targetDos.setHidden(sourceAttrs.isHidden());
                targetDos.setSystem(sourceAttrs.isSystem());
                targetDos.setArchive(sourceAttrs.isArchive());
            }
            catch (IOException e) {
                log.error("Failed to apply DOS attributes: " + e.getMessage());
            }
            return;
        }
    }
}

