/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.Chmod;
import com.fizzed.jne.EnvPath;
import com.fizzed.jne.EnvScope;
import com.fizzed.jne.EnvVar;
import com.fizzed.jne.OperatingSystem;
import com.fizzed.jne.PlatformInfo;
import com.fizzed.jne.ShellType;
import com.fizzed.jne.UserEnvironment;
import com.fizzed.jne.internal.ShellBuilder;
import com.fizzed.jne.internal.Utils;
import com.fizzed.jne.internal.WindowsRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallEnvironment {
    private static final Logger log = LoggerFactory.getLogger(InstallEnvironment.class);
    private final UserEnvironment userEnvironment;
    private final EnvScope scope;
    private final OperatingSystem operatingSystem;
    private String unitName;
    private String applicationName;
    private Path applicationRootDir;
    private Path systemRootDir;
    private Path optRootDir;
    private Path localRootDir;

    private InstallEnvironment(UserEnvironment userEnvironment, EnvScope scope, OperatingSystem operatingSystem) {
        this.userEnvironment = userEnvironment;
        this.scope = scope;
        this.operatingSystem = operatingSystem;
    }

    public UserEnvironment getUserEnvironment() {
        return this.userEnvironment;
    }

    public EnvScope getScope() {
        return this.scope;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Path getApplicationRootDir() {
        return this.applicationRootDir;
    }

    public Path getSystemRootDir() {
        return this.systemRootDir;
    }

    public Path getOptRootDir() {
        return this.optRootDir;
    }

    public Path getLocalRootDir() {
        return this.localRootDir;
    }

    public Path getApplicationDir() {
        if (this.operatingSystem == OperatingSystem.WINDOWS) {
            return this.applicationRootDir.resolve(this.applicationName);
        }
        if (this.operatingSystem == OperatingSystem.MACOS) {
            return this.applicationRootDir.resolve(this.applicationName + ".app");
        }
        return this.applicationRootDir.resolve(this.unitName);
    }

    public Path getSystemBinDir() {
        if (this.operatingSystem == OperatingSystem.WINDOWS) {
            return this.systemRootDir;
        }
        return this.systemRootDir.resolve("bin");
    }

    public Path getSystemShareDir() {
        if (this.operatingSystem == OperatingSystem.WINDOWS) {
            return this.systemRootDir;
        }
        return this.systemRootDir.resolve("share");
    }

    public Path getLocalApplicationDir() {
        return this.localRootDir.resolve(this.unitName);
    }

    public Path resolveLocalApplicationDir(boolean createIfMissing) throws IOException {
        return this.resolveDir(this.getLocalApplicationDir(), createIfMissing);
    }

    public Path getOptApplicationDir() {
        return this.optRootDir.resolve(this.unitName);
    }

    public Path resolveOptApplicationDir(boolean createIfMissing) throws IOException {
        return this.resolveDir(this.getOptApplicationDir(), createIfMissing);
    }

    public Path getLocalBinDir() {
        return this.localRootDir.resolve("bin");
    }

    public Path resolveLocalBinDir(boolean createIfMissing) throws IOException {
        return this.resolveDir(this.getLocalBinDir(), createIfMissing);
    }

    public Path getLocalShareDir() {
        return this.localRootDir.resolve("share");
    }

    public Path resolveLocalShareDir(boolean createIfMissing) throws IOException {
        return this.resolveDir(this.getLocalShareDir(), createIfMissing);
    }

    private Path resolveDir(Path dir, boolean createIfMissing) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isWritable(dir)) {
                throw new IOException("Directory " + dir + " exists but is not writable (perhaps you need to run as sudo or fix permissions?)");
            }
        } else if (createIfMissing) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (this.scope == EnvScope.USER) {
                Chmod.chmod(dir, "700");
            } else {
                Chmod.chmod(dir, "755");
            }
        } else {
            throw new IOException("Directory " + dir + " does not exist (perhaps you need to create it first then re-run your command?)");
        }
        return dir;
    }

    public void installEnv(List<EnvPath> paths) throws IOException, InterruptedException {
        this.installEnv(paths, Collections.emptyList());
    }

    public void installEnv(List<EnvPath> paths, List<EnvVar> vars) throws IOException, InterruptedException {
        List<String> shellLines;
        Path targetFile;
        List<String> shellLines2;
        Path targetFile2;
        paths = Optional.ofNullable(paths).orElseGet(Collections::emptyList);
        vars = Optional.ofNullable(vars).orElseGet(Collections::emptyList);
        ShellType shellType = this.userEnvironment.getShellType();
        List<EnvPath> filteredPaths = this.filterWellKnownEnvPaths(paths);
        if (filteredPaths.isEmpty() && vars.isEmpty()) {
            return;
        }
        List<EnvVar> blacklistedVars = this.findBlacklistedEnvVars(vars);
        if (blacklistedVars != null && !blacklistedVars.isEmpty()) {
            throw new IOException("The following environment variables are prohibited from installation: " + blacklistedVars);
        }
        if (this.operatingSystem == OperatingSystem.WINDOWS) {
            log.info("Installing the {} environment by modifying the windows registry with the following:", (Object)this.scope.toString().toLowerCase());
            log.info("");
            Map<String, String> currentEnvInRegistry = this.scope == EnvScope.USER ? WindowsRegistry.queryUserEnvironmentVariables() : WindowsRegistry.querySystemEnvironmentVariables();
            for (Object var : vars) {
                boolean exists = Utils.searchEnvVar(currentEnvInRegistry, ((EnvVar)var).getName(), ((EnvVar)var).getValue());
                if (!exists) {
                    ArrayList<String> envVarCmd = new ArrayList<String>(Arrays.asList("setx", ((EnvVar)var).getName(), ((EnvVar)var).getValue()));
                    if (this.scope == EnvScope.SYSTEM) {
                        envVarCmd.add("/M");
                    }
                    Utils.execAndGetOutput(envVarCmd);
                    log.info("  set {}={}", (Object)((EnvVar)var).getName(), (Object)((EnvVar)var).getValue());
                    continue;
                }
                log.info("  set {}={} (skipped as this already was present)", (Object)((EnvVar)var).getName(), (Object)((EnvVar)var).getValue());
            }
            String pathValueInRegistry = currentEnvInRegistry.get("PATH");
            for (EnvPath path : filteredPaths) {
                boolean exists = Utils.searchEnvPath(pathValueInRegistry, path.getValue());
                if (!exists) {
                    ArrayList<String> envVarCmd = new ArrayList<String>(Arrays.asList("setx", "PATH"));
                    pathValueInRegistry = path.isPrepend() ? Utils.joinIfDelimiterMissing(path.getValue().toString(), pathValueInRegistry, ";") : Utils.joinIfDelimiterMissing(pathValueInRegistry, path.getValue().toString(), ";");
                    envVarCmd.add(pathValueInRegistry);
                    if (this.scope == EnvScope.SYSTEM) {
                        envVarCmd.add("/M");
                    }
                    Utils.execAndGetOutput(envVarCmd);
                    log.info("  {} PATH {}", (Object)(path.isPrepend() ? "prepend" : "append"), (Object)path.getValue());
                    continue;
                }
                log.info("  {} PATH {} (skipped as this was already present)", (Object)(path.isPrepend() ? "prepend" : "append"), (Object)path.getValue());
            }
            log.info("");
            return;
        }
        if (this.operatingSystem == OperatingSystem.MACOS && this.scope == EnvScope.SYSTEM) {
            ArrayList<String> shellLines3 = new ArrayList<String>();
            for (EnvPath path : filteredPaths) {
                shellLines3.add(path.getValue().toString());
            }
            targetFile2 = Paths.get("/etc/paths.d", new String[0]).resolve(this.unitName);
            Utils.writeLinesToFile(targetFile2, shellLines3, false);
            this.logEnvWritten(targetFile2, shellLines3, false);
            filteredPaths.clear();
        }
        if (shellType == ShellType.BASH) {
            boolean append = true;
            targetFile2 = this.userEnvironment.getHomeDir().resolve(".bashrc");
            if (this.scope == EnvScope.SYSTEM) {
                Path usrLocalEtcProfileDotDir = Paths.get("/usr/local/etc/profile.d", new String[0]);
                Path etcProfileDotDir = Paths.get("/etc/profile.d", new String[0]);
                Path etcProfileFile = Paths.get("/etc/profile", new String[0]);
                if (Files.exists(usrLocalEtcProfileDotDir, new LinkOption[0]) && Files.isDirectory(usrLocalEtcProfileDotDir, new LinkOption[0])) {
                    targetFile2 = usrLocalEtcProfileDotDir.resolve(this.unitName + ".sh");
                    append = false;
                } else if (Files.exists(etcProfileDotDir, new LinkOption[0]) && Files.isDirectory(etcProfileDotDir, new LinkOption[0])) {
                    targetFile2 = etcProfileDotDir.resolve(this.unitName + ".sh");
                    append = false;
                } else if (Files.exists(etcProfileFile, new LinkOption[0])) {
                    targetFile2 = etcProfileFile;
                } else {
                    log.warn("Unable to locate system-wide profile file for BASH, will use ~/.bashrc instead");
                }
            }
            shellLines2 = this.buildShellLines(ShellType.SH, vars, filteredPaths);
            Utils.writeLinesToFileWithSectionBeginAndEndLines(targetFile2, shellLines2, append);
            this.logEnvWritten(targetFile2, shellLines2, append);
            return;
        }
        if (shellType == ShellType.ZSH) {
            targetFile = this.userEnvironment.getHomeDir().resolve(".zprofile");
            shellLines = this.buildShellLines(shellType, vars, filteredPaths);
            Utils.writeLinesToFileWithSectionBeginAndEndLines(targetFile, shellLines, true);
            this.logEnvWritten(targetFile, shellLines, true);
            return;
        }
        if (shellType == ShellType.CSH || shellType == ShellType.TCSH) {
            Path etcCshrcFile;
            targetFile = this.userEnvironment.getHomeDir().resolve(".cshrc");
            if (shellType == ShellType.TCSH) {
                targetFile = this.userEnvironment.getHomeDir().resolve(".tcshrc");
            }
            if (this.scope == EnvScope.SYSTEM && Files.exists(etcCshrcFile = Paths.get("/etc/csh.cshrc", new String[0]), new LinkOption[0])) {
                targetFile = etcCshrcFile;
            }
            shellLines = this.buildShellLines(shellType, vars, filteredPaths);
            Utils.writeLinesToFileWithSectionBeginAndEndLines(targetFile, shellLines, true);
            this.logEnvWritten(targetFile, shellLines, true);
            return;
        }
        if (shellType == ShellType.KSH || shellType == ShellType.ASH || shellType == ShellType.SH) {
            boolean append = true;
            targetFile2 = this.userEnvironment.getHomeDir().resolve(".profile");
            if (this.scope == EnvScope.SYSTEM) {
                Path etcProfileDotDir = Paths.get("/etc/profile.d", new String[0]);
                Path etcProfileFile = Paths.get("/etc/profile", new String[0]);
                if (Files.exists(etcProfileDotDir, new LinkOption[0]) && Files.isDirectory(etcProfileDotDir, new LinkOption[0])) {
                    targetFile2 = etcProfileDotDir.resolve(this.unitName + ".sh");
                    append = false;
                } else if (Files.exists(etcProfileFile, new LinkOption[0])) {
                    targetFile2 = etcProfileFile;
                } else {
                    log.warn("Unable to locate system-wide profile file for KSH, will use ~/.profile instead");
                }
            }
            shellLines2 = this.buildShellLines(shellType, vars, filteredPaths);
            Utils.writeLinesToFileWithSectionBeginAndEndLines(targetFile2, shellLines2, append);
            this.logEnvWritten(targetFile2, shellLines2, append);
            return;
        }
        log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        log.warn("");
        log.warn("Unable to install environment for shell type {} (we don't have support for it yet)", (Object)shellType);
        log.warn("");
        log.warn("You will need to install the following environment variables and paths yourself.");
        log.warn("Here is some POSIX-compliant example code:");
        log.warn("");
        ShellBuilder shellBuilder = new ShellBuilder(ShellType.SH);
        for (EnvVar var : vars) {
            log.warn("  {}", (Object)shellBuilder.exportEnvVar(var));
        }
        for (EnvPath path : paths) {
            log.warn("  {}", (Object)shellBuilder.addEnvPath(path));
        }
        log.warn("");
        log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    private List<String> buildShellLines(ShellType shellType, List<EnvVar> vars, List<EnvPath> paths) {
        ArrayList<String> shellLines = new ArrayList<String>();
        ShellBuilder shellBuilder = new ShellBuilder(shellType);
        shellLines.addAll(shellBuilder.sectionBegin(this.unitName));
        if (vars != null) {
            for (EnvVar var : vars) {
                shellLines.add(shellBuilder.exportEnvVar(var));
            }
        }
        if (paths != null) {
            for (EnvPath path : paths) {
                shellLines.add(shellBuilder.addEnvPath(path));
            }
        }
        shellLines.addAll(shellBuilder.sectionEnd(this.unitName));
        return shellLines;
    }

    private void logEnvWritten(Path file, List<String> shellLines, boolean append) {
        String appendStr = append ? "appending/replacing" : "writing";
        log.info("Installed the {} {} environment by {} the following to {}:", new Object[]{this.scope.toString().toLowerCase(), this.userEnvironment.getShellType().toString().toLowerCase(), appendStr, file});
        log.info("");
        for (String line : shellLines) {
            log.info("  {}", (Object)line);
        }
        log.info("");
    }

    private List<EnvPath> filterWellKnownEnvPaths(List<EnvPath> paths) {
        if (paths == null) {
            return null;
        }
        Set<Path> wellKnownSystemPaths = this.wellKnownEnvPaths();
        ArrayList<EnvPath> filteredPaths = new ArrayList<EnvPath>();
        for (EnvPath path : paths) {
            if (wellKnownSystemPaths.contains(path.getValue())) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    private Set<Path> wellKnownEnvPaths() {
        HashSet<Path> wellKnownPaths = new HashSet<Path>();
        wellKnownPaths.add(Paths.get("/bin", new String[0]));
        wellKnownPaths.add(Paths.get("/usr/bin", new String[0]));
        wellKnownPaths.add(Paths.get("/usr/sbin", new String[0]));
        wellKnownPaths.add(Paths.get("/usr/local/bin", new String[0]));
        wellKnownPaths.add(Paths.get("/usr/local/sbin", new String[0]));
        wellKnownPaths.add(Paths.get("C:\\Windows\\System32", new String[0]));
        return wellKnownPaths;
    }

    private List<EnvVar> findBlacklistedEnvVars(List<EnvVar> vars) {
        if (vars == null) {
            return null;
        }
        Set<String> blacklistedEnvVars = this.blacklistedEnvVars();
        ArrayList<EnvVar> matched = new ArrayList<EnvVar>();
        for (EnvVar var : vars) {
            if (!blacklistedEnvVars.contains(var.getName())) continue;
            matched.add(var);
        }
        return matched;
    }

    private Set<String> blacklistedEnvVars() {
        TreeSet<String> blacklistedVars = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        blacklistedVars.add("PATH");
        return blacklistedVars;
    }

    public static InstallEnvironment detect(String applicationName, String unitName) {
        return InstallEnvironment.detect(applicationName, unitName, EnvScope.SYSTEM);
    }

    public static InstallEnvironment detect(String applicationName, String unitName, EnvScope scope) {
        return InstallEnvironment.detect(applicationName, unitName, scope, UserEnvironment.detectLogical());
    }

    public static InstallEnvironment detect(String applicationName, String unitName, EnvScope scope, UserEnvironment userEnvironment) {
        if (applicationName == null || unitName == null) {
            throw new IllegalArgumentException("applicationName and unitName must not be null");
        }
        if (!unitName.matches("^[a-z0-9\\-_]+$")) {
            throw new IllegalArgumentException("unitName must be all lowercase, can include a hypen or underscore, but no whitespace");
        }
        OperatingSystem os = PlatformInfo.detectOperatingSystem();
        InstallEnvironment ie = new InstallEnvironment(userEnvironment, scope, os);
        ie.applicationName = applicationName;
        ie.unitName = unitName;
        if (scope == EnvScope.USER) {
            UserEnvironment ue = UserEnvironment.detectLogical();
            ie.systemRootDir = ie.localRootDir = ue.getHomeDir().resolve(".local");
            ie.applicationRootDir = ue.getHomeDir().resolve("Applications");
            ie.optRootDir = ie.localRootDir;
        } else if (os == OperatingSystem.LINUX) {
            ie.localRootDir = Paths.get("/usr/local", new String[0]);
            ie.systemRootDir = Paths.get("/usr", new String[0]);
            ie.optRootDir = ie.applicationRootDir = Paths.get("/opt", new String[0]);
        } else if (os == OperatingSystem.FREEBSD || os == OperatingSystem.OPENBSD || os == OperatingSystem.NETBSD || os == OperatingSystem.DRAGONFLYBSD) {
            ie.localRootDir = Paths.get("/usr/local", new String[0]);
            ie.systemRootDir = Paths.get("/usr", new String[0]);
            ie.optRootDir = ie.applicationRootDir = ie.localRootDir;
        } else if (os == OperatingSystem.MACOS) {
            ie.localRootDir = Paths.get("/usr/local", new String[0]);
            ie.systemRootDir = Paths.get("/usr", new String[0]);
            ie.applicationRootDir = Paths.get("/Applications", new String[0]);
            ie.optRootDir = Paths.get("/opt", new String[0]);
        } else if (os == OperatingSystem.WINDOWS) {
            String programFiles = Utils.trimToNull(System.getenv("ProgramFiles"));
            String systemRoot = Utils.trimToNull(System.getenv("SystemRoot"));
            String systemDrive = Utils.trimToNull(System.getenv("SystemDrive"));
            if (programFiles == null) {
                programFiles = "C:\\Program Files";
                log.warn("Windows ProgramFiles environment variable not set, assuming {}", (Object)programFiles);
            }
            if (systemRoot == null) {
                if (systemDrive != null) {
                    systemRoot = systemDrive + "\\Windows";
                }
                if (systemRoot == null) {
                    systemRoot = "C:\\Windows";
                    log.warn("Windows SystemRoot environment variable not set, assuming {}", (Object)systemRoot);
                }
            }
            ie.applicationRootDir = Paths.get(programFiles, new String[0]);
            ie.systemRootDir = Paths.get(systemRoot, new String[0]).resolve("system32");
            ie.optRootDir = ie.localRootDir = ie.applicationRootDir.resolve("..").resolve("Opt").normalize();
        }
        return ie;
    }
}

