/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.ABI;
import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.NativeTarget;
import com.fizzed.jne.OperatingSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NativeLanguageModel {
    private final Map<String, String> values = new HashMap<String, String>();
    private final Map<OperatingSystem, String> operatingSystems = new HashMap<OperatingSystem, String>();
    private final Map<HardwareArchitecture, String> hardwareArchitectures = new HashMap<HardwareArchitecture, String>();
    private final Map<ABI, String> abis = new HashMap<ABI, String>();

    public NativeLanguageModel add(String from, String to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        this.values.put(from, to);
        return this;
    }

    public NativeLanguageModel add(OperatingSystem from, String to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        this.operatingSystems.put(from, to);
        return this;
    }

    public NativeLanguageModel add(HardwareArchitecture from, String to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        this.hardwareArchitectures.put(from, to);
        return this;
    }

    public NativeLanguageModel add(ABI from, String to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        this.abis.put(from, to);
        return this;
    }

    public String format(String key) {
        if (key != null) {
            return this.values.get(key);
        }
        return null;
    }

    public String format(OperatingSystem os) {
        if (os != null) {
            String v = this.operatingSystems.get((Object)os);
            if (v == null) {
                return os.name().toLowerCase();
            }
            return v;
        }
        return null;
    }

    public String format(HardwareArchitecture arch) {
        if (arch != null) {
            String v = this.hardwareArchitectures.get((Object)arch);
            if (v == null) {
                return arch.name().toLowerCase();
            }
            return v;
        }
        return null;
    }

    public String format(ABI abi) {
        if (abi != null) {
            String v = this.abis.get((Object)abi);
            if (v == null) {
                return abi.name().toLowerCase();
            }
            return v;
        }
        return null;
    }

    public String format(String template, NativeTarget nativeTarget) {
        if (nativeTarget != null) {
            return this.format(template, nativeTarget.getOperatingSystem(), nativeTarget.getHardwareArchitecture(), nativeTarget.getAbi());
        }
        return null;
    }

    public String format(String template, OperatingSystem os, HardwareArchitecture arch, ABI abi) {
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        String optFront = null;
        String key = null;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (!started) {
                if (c == '{') {
                    started = true;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '}') {
                started = false;
                String v = null;
                if ("os".equals(key)) {
                    v = this.format(os);
                } else if ("arch".equals(key)) {
                    v = this.format(arch);
                } else if ("abi".equals(key)) {
                    v = this.format(abi);
                } else {
                    v = this.format(key);
                    if (v == null) {
                        throw new IllegalArgumentException("Unknown key: " + key + " in template: " + template);
                    }
                }
                if (v != null) {
                    if (optFront != null) {
                        sb.append(optFront);
                    }
                    sb.append(v);
                }
                optFront = null;
                key = null;
                continue;
            }
            if (c == '?') {
                optFront = key;
                key = null;
                continue;
            }
            key = key != null ? key + c : "" + c;
        }
        return sb.toString();
    }
}

