/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum JavaDistribution {
    ZULU("Zulu", "Azul Systems", "https://www.azul.com/downloads", new String[]{"zulu", "azul"}),
    LIBERICA("Liberica", "BellSoft", "https://bell-sw.com/libericajdk", new String[]{"liberica", "bellsoft"}),
    TEMURIN("Temurin", "Eclipse", "https://adoptium.net", new String[]{"temurin", "eclipse", "adoptium"}),
    CORRETTO("Corretto", "Amazon", "https://docs.aws.amazon.com/corretto", new String[]{"corretto", "amazon"}),
    MICROSOFT("Microsoft", "Microsoft", "https://learn.microsoft.com/en-us/java/openjdk", new String[]{"microsoft"}),
    SEMERU("Semeru", "IBM", "https://developer.ibm.com/languages/java/semeru-runtimes", new String[]{"ibm", "semeru"}),
    ORACLE("Oracle", "Oracle", "https://www.oracle.com/java/technologies/downloads", new String[]{"oracle"}),
    DRAGONWELL("DragonWell", "Alibaba", "https://dragonwell-jdk.io", new String[]{"alibaba", "dragonwell"}),
    NITRO("Nitro", "Fizzed", "https://github.com/fizzed/nitro", new String[]{"fizzed", "nitro"}),
    JBR("JBR", "JetBrains", "https://github.com/JetBrains/JetBrainsRuntime", new String[]{"jetbrains"}),
    SAPMACHINE("SapMachine", "SAP", "https://sap.github.io/SapMachine", new String[]{"sap", "sapmachine"}),
    REDHAT("OpenJDK", "RedHat", null, new String[]{"redhat"}),
    DEBIAN("OpenJDK", "Debian", null, new String[]{"debian"}),
    UBUNTU("OpenJDK", "Ubuntu", null, new String[]{"ubuntu"}),
    HOMEBREW("OpenJDK", "HomeBrew", null, new String[]{"homebrew"});

    private final String descriptor;
    private final String vendor;
    private final String distroUrl;
    private final String[] keywords;

    private JavaDistribution(String descriptor, String vendor, String distroUrl, String[] keywords) {
        this.descriptor = descriptor;
        this.vendor = vendor;
        this.distroUrl = distroUrl;
        this.keywords = keywords;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDistroUrl() {
        return this.distroUrl;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public static JavaDistribution resolve(String value) {
        if (value == null) {
            return null;
        }
        value = value.toLowerCase();
        for (JavaDistribution distro : JavaDistribution.values()) {
            if (distro.keywords == null) continue;
            for (String keyword : distro.keywords) {
                if (!value.contains(keyword)) continue;
                return distro;
            }
        }
        return null;
    }
}

