/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum HardwareArchitecture {
    X32("x32", new String[]{"i386", "i586", "i686"}, new String[]{"x86"}),
    X64("x64", new String[]{"x86_64", "amd64"}),
    ARMEL("armel", null, new String[]{"arm32v5", "arm32v6"}),
    ARMHF("armhf", null, new String[]{"arm32v7", "armv7l"}),
    ARM64("arm64", new String[]{"aarch64"}, new String[]{"arm64v8"}),
    RISCV64("riscv64", null, new String[]{"riscv64gc"}),
    MIPS64LE("mips64le", new String[]{"mips64el"}),
    S390X("s390x", null),
    PPC64LE("ppc64le", null),
    PPC64("ppc64", null);

    private final String descriptor;
    private final String[] aliases;
    private final String[] extraAliases;

    private HardwareArchitecture(String descriptor, String[] aliases) {
        this(descriptor, aliases, null);
    }

    private HardwareArchitecture(String descriptor, String[] aliases, String[] extraAliases) {
        this.descriptor = descriptor;
        this.aliases = aliases;
        this.extraAliases = extraAliases;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getExtraAliases() {
        return this.extraAliases;
    }

    public static HardwareArchitecture resolve(String value) {
        for (HardwareArchitecture arch : HardwareArchitecture.values()) {
            if (arch.name().equalsIgnoreCase(value)) {
                return arch;
            }
            if (arch.aliases != null) {
                for (String alias : arch.aliases) {
                    if (!alias.equalsIgnoreCase(value)) continue;
                    return arch;
                }
            }
            if (arch.extraAliases == null) continue;
            for (String alias : arch.extraAliases) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return arch;
            }
        }
        return null;
    }
}

