/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utils {
    public static String readFileToString(Path file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("File not found: " + file);
        }
        byte[] bytes = Files.readAllBytes(file);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String trimToNull(String value) {
        if (value != null && (value = value.trim()).equals("")) {
            return null;
        }
        return value;
    }

    public static Path which(String nameOfExeOrBin) {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] paths;
            for (String p : paths = path.split(File.pathSeparator)) {
                Path pathDir = Paths.get(p, new String[0]);
                Path exeFile = pathDir.resolve(nameOfExeOrBin);
                if (!Files.exists(exeFile, new LinkOption[0])) continue;
                return exeFile;
            }
        }
        return null;
    }

    public static String execAndGetOutput(List<String> commands) throws IOException, InterruptedException {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder(commands.toArray(new String[0]));
        Process process = processBuilder.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
        }
        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        try {
            while ((line = reader.readLine()) != null) {
                System.err.println(line);
            }
        }
        finally {
            reader.close();
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException("Process exited with a non-zero code (actual " + exitCode + ")");
        }
        return output.toString();
    }

    public static boolean searchEnvVar(String name, String value) {
        return Utils.searchEnvVar(System.getenv(), name, value);
    }

    public static boolean searchEnvVar(Map<String, String> env, String name, String value) {
        String currentEnvVar = Utils.trimToNull(env.get(name));
        return currentEnvVar != null && currentEnvVar.equals(value);
    }

    public static boolean searchEnvPath(Path path) {
        return Utils.searchEnvPath(System.getenv(), path);
    }

    public static boolean searchEnvPath(Map<String, String> env, Path path) {
        return Utils.searchEnvPath(Utils.trimToNull(env.get("PATH")), path);
    }

    public static boolean searchEnvPath(String pathValueInEnv, Path path) {
        String[] currentPathVarParts;
        for (String currentPathVarPart : currentPathVarParts = pathValueInEnv != null ? pathValueInEnv.split(File.pathSeparator) : new String[]{}) {
            if (currentPathVarPart == null || !currentPathVarPart.equalsIgnoreCase(path.toString())) continue;
            return true;
        }
        return false;
    }

    public static String joinIfDelimiterMissing(String v1, String v2, String delimiter) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1.endsWith(delimiter)) {
            return v1 + v2;
        }
        return v1 + delimiter + v2;
    }

    public static List<String> filterLinesIfPresentInFile(Path file, List<String> lines) throws IOException {
        if (lines == null) {
            return new ArrayList<String>();
        }
        if (lines.isEmpty() || file == null || !Files.exists(file, new LinkOption[0])) {
            return new ArrayList<String>(lines);
        }
        HashSet<String> linesInList = new HashSet<String>(lines);
        HashSet linesToRemove = new HashSet();
        try (Stream<String> fileStream = Files.lines(file, StandardCharsets.UTF_8);){
            fileStream.forEach(fileLine -> {
                if (linesInList.contains(fileLine)) {
                    linesToRemove.add(fileLine);
                }
            });
        }
        return lines.stream().filter(line -> !linesToRemove.contains(line)).collect(Collectors.toList());
    }

    public static void writeLinesToFile(Path file, List<String> lines, boolean append) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (append && !lines.isEmpty() && Files.exists(file, new LinkOption[0])) {
            int newlinesNeededCount = Utils.newlinesNeededForAppending(file);
            for (int i = 0; i < newlinesNeededCount; ++i) {
                sb.append("\n");
            }
        }
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        if (append) {
            Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        } else {
            Files.write(file, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static int newlinesNeededForAppending(Path file) throws IOException {
        StringBuilder currentLine = new StringBuilder();
        int lineCount = 0;
        boolean wasLastLine2Empty = false;
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            int charCode;
            while ((charCode = reader.read()) != -1) {
                char c = (char)charCode;
                currentLine.append(c);
                if (c != '\n') continue;
                ++lineCount;
                wasLastLine2Empty = currentLine.toString().trim().length() == 0;
                currentLine.setLength(0);
            }
        }
        String lastLine = currentLine.toString();
        if (lastLine.length() == 0) {
            if (lineCount == 0) {
                return 0;
            }
            if (wasLastLine2Empty) {
                return 0;
            }
            return 1;
        }
        if (lastLine.trim().length() == 0) {
            return 1;
        }
        return 2;
    }

    public static boolean endsWithNewlineForAppending(Path path) throws IOException {
        boolean bl;
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        long fileSize = Files.size(path);
        if (fileSize == 0L) {
            return true;
        }
        RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");
        try {
            raf.seek(fileSize - 1L);
            int lastByte = raf.read();
            bl = lastByte == 10;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Error accessing file to check newline status: " + path, e);
            }
        }
        raf.close();
        return bl;
    }
}

