/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public class JavaVersion
implements Comparable<JavaVersion> {
    private final String source;
    private final int major;
    private final int minor;
    private final int security;
    private final int build;

    public JavaVersion(String source, int major, int minor, int security, int build) {
        this.source = source;
        this.major = major;
        this.minor = minor;
        this.security = security;
        this.build = build;
    }

    public String getSource() {
        return this.source;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getSecurity() {
        return this.security;
    }

    public int getBuild() {
        return this.build;
    }

    public String toJavaVersion() {
        if (this.major < 9) {
            return "1." + this.major + "." + this.minor + "_" + this.security;
        }
        return this.toSemanticVersion();
    }

    public String toSemanticVersion() {
        if (this.build > 0) {
            return this.major + "." + this.minor + "." + this.security + "." + this.build;
        }
        return this.major + "." + this.minor + "." + this.security;
    }

    public String toString() {
        return this.toSemanticVersion();
    }

    @Override
    public int compareTo(JavaVersion other) {
        if (other == null) {
            return -1;
        }
        int c = Integer.compare(this.major, other.major);
        if (c == 0 && (c = Integer.compare(this.minor, other.minor)) == 0 && (c = Integer.compare(this.security, other.security)) == 0) {
            c = Integer.compare(this.build, other.build);
        }
        return c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.security != that.security) {
            return false;
        }
        return this.build == that.build;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.security;
        result = 31 * result + this.build;
        return result;
    }

    public static JavaVersion current() {
        String version = System.getProperty("java.version");
        return JavaVersion.parse(version);
    }

    public static JavaVersion parse(String version) {
        if (version == null) {
            throw new IllegalArgumentException("java version was null");
        }
        int major = 0;
        int minor = 0;
        int security = 0;
        int build = 0;
        try {
            String sourceVersion = version;
            if (version.startsWith("1.")) {
                sourceVersion = version.substring(2).replace('_', '.').replace('-', '.');
            }
            int len = sourceVersion.length();
            int periodPos1 = sourceVersion.indexOf(46);
            major = Integer.parseInt(sourceVersion.substring(0, periodPos1 > 0 ? periodPos1 : len));
            if (periodPos1 > 0 && periodPos1 < len - 1) {
                int periodPos2 = sourceVersion.indexOf(46, periodPos1 + 1);
                minor = Integer.parseInt(sourceVersion.substring(periodPos1 + 1, periodPos2 > 0 ? periodPos2 : len));
                if (periodPos2 > 0 && periodPos2 < len - 1) {
                    int periodPos3 = sourceVersion.indexOf(46, periodPos2 + 1);
                    security = Integer.parseInt(sourceVersion.substring(periodPos2 + 1, periodPos3 > 0 ? periodPos3 : len));
                    if (periodPos3 > 0 && periodPos3 < len - 1) {
                        build = Integer.parseInt(sourceVersion.substring(periodPos3 + 1));
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("java version [" + version + "] invalid format: not of X.X.X", e);
        }
        return new JavaVersion(version, major, minor, security, build);
    }
}

