/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

public class MacReleases {
    public static String getVersionName(int major, int minor) {
        switch (major) {
            case 26: {
                return "Tahoe";
            }
            case 15: {
                return "Sequoia";
            }
            case 14: {
                return "Sonoma";
            }
            case 13: {
                return "Ventura";
            }
            case 12: {
                return "Monterey";
            }
            case 11: {
                return "Big Sur";
            }
            case 10: {
                switch (minor) {
                    case 15: {
                        return "Catalina";
                    }
                    case 14: {
                        return "Mojave";
                    }
                    case 13: {
                        return "High Sierra";
                    }
                    case 12: {
                        return "Sierra";
                    }
                    case 11: {
                        return "El Capitan";
                    }
                    case 10: {
                        return "Yosemite";
                    }
                    case 9: {
                        return "Mavericks";
                    }
                    case 8: {
                        return "Mountain Lion";
                    }
                    case 7: {
                        return "Lion";
                    }
                    case 6: {
                        return "Snow Leopard";
                    }
                    case 5: {
                        return "Leopard";
                    }
                    case 4: {
                        return "Tiger";
                    }
                    case 3: {
                        return "Panther";
                    }
                    case 2: {
                        return "Jaguar";
                    }
                    case 1: {
                        return "Puma";
                    }
                    case 0: {
                        return "Cheetah";
                    }
                }
                return "Mac OS X 10." + minor;
            }
        }
        return null;
    }

    public static String getVersionName(String productVersion) {
        if (productVersion == null || productVersion.isEmpty()) {
            return null;
        }
        try {
            String[] parts = productVersion.split("\\.");
            if (parts.length >= 1) {
                int major = Integer.parseInt(parts[0]);
                int minor = 0;
                if (parts.length > 1) {
                    minor = Integer.parseInt(parts[1]);
                }
                return MacReleases.getVersionName(major, minor);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }
}

