/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.MemoizedInitializer;
import com.fizzed.jne.OperatingSystem;
import com.fizzed.jne.PlatformInfo;
import com.fizzed.jne.ShellType;
import com.fizzed.jne.internal.EtcPasswd;
import com.fizzed.jne.internal.MacDscl;
import com.fizzed.jne.internal.SystemExecutor;
import com.fizzed.jne.internal.Utils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserEnvironment {
    private static final Logger log = LoggerFactory.getLogger(UserEnvironment.class);
    private String user;
    private Boolean elevated;
    private Path homeDir;
    private Integer userId;
    private Integer groupId;
    private String displayName;
    private Path shell;
    private ShellType shellType;
    private static final MemoizedInitializer<UserEnvironment> effectiveUserEnvironmentRef = new MemoizedInitializer();
    private static final MemoizedInitializer<UserEnvironment> logicalUserEnvironmentRef = new MemoizedInitializer();

    public String getUser() {
        return this.user;
    }

    public Boolean isElevated() {
        return this.elevated;
    }

    public Path getHomeDir() {
        return this.homeDir;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Path getShell() {
        return this.shell;
    }

    public ShellType getShellType() {
        return this.shellType;
    }

    public static UserEnvironment detectEffective() {
        return effectiveUserEnvironmentRef.once(() -> UserEnvironment.detect(false));
    }

    public static UserEnvironment detectLogical() {
        return logicalUserEnvironmentRef.once(() -> UserEnvironment.detect(true));
    }

    private static UserEnvironment detect(boolean logical) {
        String elevatedUser;
        UserEnvironment userEnvironment = new UserEnvironment();
        String user = Utils.trimToNull(System.getenv("USER"));
        if (user == null) {
            user = System.getenv("USERNAME");
        }
        if ((elevatedUser = Utils.trimToNull(System.getenv("SUDO_USER"))) == null) {
            elevatedUser = Utils.trimToNull(System.getenv("DOAS_USER"));
        }
        userEnvironment.user = user;
        userEnvironment.elevated = false;
        if (logical && elevatedUser != null) {
            userEnvironment.user = elevatedUser;
        }
        if (elevatedUser != null) {
            userEnvironment.elevated = true;
        }
        OperatingSystem os = PlatformInfo.detectOperatingSystem();
        if (!userEnvironment.elevated.booleanValue()) {
            if (os == OperatingSystem.WINDOWS) {
                String systemDrive = Utils.trimToNull(System.getenv("SystemDrive"));
                if (systemDrive != null) {
                    Path systemDir = Paths.get(systemDrive + "\\Windows", new String[0]).resolve("system32");
                    userEnvironment.elevated = Files.isWritable(systemDir);
                }
            } else if ("root".equals(user)) {
                userEnvironment.elevated = true;
            } else {
                try {
                    String output = SystemExecutor.LOCAL.execProcess("id", "-u").trim();
                    if ("0".equals(output)) {
                        userEnvironment.elevated = true;
                    }
                    userEnvironment.userId = Integer.valueOf(output);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        UserEnvironment.detectHomeAndShellType(os, userEnvironment);
        return userEnvironment;
    }

    private static void detectHomeAndShellType(OperatingSystem os, UserEnvironment userEnvironment) {
        EtcPasswd etcPasswd = EtcPasswd.detect();
        if (etcPasswd != null) {
            EtcPasswd.Entry entry = null;
            entry = etcPasswd.findEntryByUserName(userEnvironment.user);
            if (entry == null && userEnvironment.userId != null) {
                entry = etcPasswd.findEntryByUserId(userEnvironment.userId);
            }
            if (entry != null) {
                if (userEnvironment.user == null) {
                    userEnvironment.user = entry.getUsername();
                }
                log.debug("Using /etc/passwd for detecting user environment for {}", (Object)userEnvironment.user);
                userEnvironment.homeDir = Paths.get(entry.getHome(), new String[0]);
                userEnvironment.userId = entry.getUserId();
                userEnvironment.groupId = entry.getGroupId();
                userEnvironment.displayName = entry.getName();
                userEnvironment.shell = Paths.get(entry.getShell(), new String[0]);
                userEnvironment.shellType = ShellType.detectFromBin(entry.getShell());
                return;
            }
        }
        if (os == OperatingSystem.MACOS) {
            try {
                MacDscl macDscl = MacDscl.readByUser(userEnvironment.user);
                if (macDscl != null) {
                    log.debug("Using dscl output for detecting user environment for {}", (Object)userEnvironment.user);
                    userEnvironment.homeDir = macDscl.getHomeDir();
                    userEnvironment.userId = macDscl.getUniqueId();
                    userEnvironment.groupId = macDscl.getPrimaryGroupId();
                    userEnvironment.displayName = macDscl.getRealName();
                    userEnvironment.shell = macDscl.getShell();
                    userEnvironment.shellType = ShellType.detectFromBin(macDscl.getShell().toString());
                    return;
                }
            }
            catch (Exception e) {
                log.error("Unable to cleanly read dscl output", (Throwable)e);
            }
        }
        if (os == OperatingSystem.WINDOWS) {
            Path powershellExe;
            log.debug("Using windows env vars for user environment for {}", (Object)userEnvironment.user);
            String homeDrive = Utils.trimToNull(System.getenv("HOMEDRIVE"));
            String homePath = Utils.trimToNull(System.getenv("HOMEPATH"));
            if (homeDrive != null && homePath != null) {
                userEnvironment.homeDir = Paths.get(homeDrive + homePath, new String[0]);
            }
            if ((powershellExe = Utils.which("powershell.exe")) != null) {
                userEnvironment.shell = powershellExe;
                userEnvironment.shellType = ShellType.PS;
            } else {
                Path cmdExe = Utils.which("cmd.exe");
                if (cmdExe != null) {
                    userEnvironment.shell = cmdExe;
                    userEnvironment.shellType = ShellType.CMD;
                }
            }
        }
    }
}

