/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class SystemFilePermission {
    private final String octalPermission;
    private final String symbolicPermission;
    private final Set<PosixFilePermission> posixFilePermissions;

    private SystemFilePermission(String octalPermission, String symbolicPermission) {
        this.octalPermission = octalPermission;
        this.symbolicPermission = symbolicPermission;
        this.posixFilePermissions = PosixFilePermissions.fromString(symbolicPermission);
    }

    public String getOctalPermission() {
        return this.octalPermission;
    }

    public String getSymbolicPermission() {
        return this.symbolicPermission;
    }

    public Set<PosixFilePermission> getPosixFilePermissions() {
        return this.posixFilePermissions;
    }

    public String toString() {
        return this.octalPermission;
    }

    public static SystemFilePermission parseOctalPermissions(String octalPermission) {
        if (octalPermission == null || !octalPermission.matches("^[0-7]{3}$")) {
            throw new IllegalArgumentException("Invalid file octal permission format '" + octalPermission + "' (must be 3 digits in length and only 0-7 such as 755)");
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < octalPermission.length(); ++i) {
            int octalDigit = Character.digit(octalPermission.charAt(i), 10);
            switch (octalDigit) {
                case 7: {
                    sb.append("rwx");
                    continue block10;
                }
                case 6: {
                    sb.append("rw-");
                    continue block10;
                }
                case 5: {
                    sb.append("r-x");
                    continue block10;
                }
                case 4: {
                    sb.append("r--");
                    continue block10;
                }
                case 3: {
                    sb.append("-wx");
                    continue block10;
                }
                case 2: {
                    sb.append("-w-");
                    continue block10;
                }
                case 1: {
                    sb.append("--x");
                    continue block10;
                }
                case 0: {
                    sb.append("---");
                }
            }
        }
        return new SystemFilePermission(octalPermission, sb.toString());
    }
}

