/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.SystemFilePermission;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Chmod {
    public static void chmod(Path path, String octalPermission) throws IOException {
        SystemFilePermission permission = SystemFilePermission.parseOctalPermissions(octalPermission);
        Chmod.chmod(path, permission);
    }

    public static void chmod(Path path, SystemFilePermission permission) throws IOException {
        try {
            Files.setPosixFilePermissions(path, permission.getPosixFilePermissions());
        }
        catch (UnsupportedOperationException e) {
            Chmod.applyWindowsAclWithAdminOverride(path, permission.getPosixFilePermissions());
        }
    }

    private static void applyLegacyPermissions(File file, Set<PosixFilePermission> perms) {
        if (file == null || perms == null || !file.exists()) {
            return;
        }
        boolean ownerRead = perms.contains((Object)PosixFilePermission.OWNER_READ);
        boolean ownerWrite = perms.contains((Object)PosixFilePermission.OWNER_WRITE);
        boolean ownerExecute = perms.contains((Object)PosixFilePermission.OWNER_EXECUTE);
        file.setReadable(ownerRead, true);
        file.setWritable(ownerWrite, true);
        file.setExecutable(ownerExecute, true);
        boolean everybodyRead = perms.contains((Object)PosixFilePermission.GROUP_READ) && perms.contains((Object)PosixFilePermission.OTHERS_READ);
        boolean everybodyWrite = perms.contains((Object)PosixFilePermission.GROUP_WRITE) && perms.contains((Object)PosixFilePermission.OTHERS_WRITE);
        boolean everybodyExecute = perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) && perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
        file.setReadable(everybodyRead, false);
        file.setWritable(everybodyWrite, false);
        file.setExecutable(everybodyExecute, false);
    }

    private static void applyWindowsAclWithAdminOverride(Path path, Set<PosixFilePermission> posixPerms) throws IOException, UnsupportedOperationException {
        UserPrincipal everyonePrincipal;
        GroupPrincipal administratorsGroup;
        AclFileAttributeView aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        if (aclView == null) {
            throw new UnsupportedOperationException("AclFileAttributeView is not supported on this file system.");
        }
        UserPrincipalLookupService lookupService = path.getFileSystem().getUserPrincipalLookupService();
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        UserPrincipal owner = Files.getOwner(path, new LinkOption[0]);
        try {
            administratorsGroup = lookupService.lookupPrincipalByGroupName("Administrators");
        }
        catch (UserPrincipalNotFoundException e) {
            throw new IOException("Could not find the 'Administrators' group principal.", e);
        }
        try {
            everyonePrincipal = lookupService.lookupPrincipalByName("EVERYONE@");
        }
        catch (UserPrincipalNotFoundException e) {
            everyonePrincipal = lookupService.lookupPrincipalByName("Everyone");
        }
        boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
        Set<AclEntryPermission> ownerAclPerms = Chmod.mapPosixToAclPermissions(posixPerms, "OWNER", isDirectory);
        Set<AclEntryPermission> othersAclPerms = Chmod.mapPosixToAclPermissions(posixPerms, "OTHERS", isDirectory);
        HashSet<AclEntryPermission> adminFullControl = new HashSet<AclEntryPermission>();
        adminFullControl.add(AclEntryPermission.READ_ACL);
        adminFullControl.add(AclEntryPermission.WRITE_ACL);
        adminFullControl.add(AclEntryPermission.READ_ATTRIBUTES);
        adminFullControl.add(AclEntryPermission.WRITE_ATTRIBUTES);
        adminFullControl.add(AclEntryPermission.SYNCHRONIZE);
        adminFullControl.add(AclEntryPermission.DELETE);
        adminFullControl.add(AclEntryPermission.WRITE_OWNER);
        adminFullControl.add(AclEntryPermission.READ_DATA);
        adminFullControl.add(AclEntryPermission.EXECUTE);
        adminFullControl.add(AclEntryPermission.WRITE_DATA);
        adminFullControl.add(AclEntryPermission.APPEND_DATA);
        adminFullControl.add(AclEntryPermission.DELETE_CHILD);
        adminFullControl.add(AclEntryPermission.LIST_DIRECTORY);
        adminFullControl.add(AclEntryPermission.ADD_FILE);
        adminFullControl.add(AclEntryPermission.ADD_SUBDIRECTORY);
        AclEntry adminEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(administratorsGroup).setPermissions(adminFullControl).setFlags(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT).build();
        aclEntries.add(adminEntry);
        if (!ownerAclPerms.isEmpty()) {
            AclEntry ownerEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(owner).setPermissions(ownerAclPerms).setFlags(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT).build();
            aclEntries.add(ownerEntry);
        }
        if (!othersAclPerms.isEmpty()) {
            AclEntry everyoneEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(everyonePrincipal).setPermissions(othersAclPerms).setFlags(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT).build();
            aclEntries.add(everyoneEntry);
        }
        aclView.setAcl(aclEntries);
    }

    private static Set<AclEntryPermission> mapPosixToAclPermissions(Set<PosixFilePermission> posixPerms, String principalType, boolean isDirectory) {
        HashSet<AclEntryPermission> aclPermissions = new HashSet<AclEntryPermission>();
        String readPerm = principalType + "_READ";
        String writePerm = principalType + "_WRITE";
        String execPerm = principalType + "_EXECUTE";
        boolean read = posixPerms.contains((Object)PosixFilePermission.valueOf(readPerm));
        boolean write = posixPerms.contains((Object)PosixFilePermission.valueOf(writePerm));
        boolean execute = posixPerms.contains((Object)PosixFilePermission.valueOf(execPerm));
        if (read) {
            aclPermissions.add(AclEntryPermission.READ_DATA);
            aclPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            aclPermissions.add(AclEntryPermission.SYNCHRONIZE);
            if (isDirectory) {
                aclPermissions.add(AclEntryPermission.LIST_DIRECTORY);
            }
        }
        if (write) {
            aclPermissions.add(AclEntryPermission.WRITE_DATA);
            aclPermissions.add(AclEntryPermission.APPEND_DATA);
            aclPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            if (isDirectory) {
                aclPermissions.add(AclEntryPermission.ADD_FILE);
                aclPermissions.add(AclEntryPermission.ADD_SUBDIRECTORY);
            }
        }
        if (execute) {
            aclPermissions.add(AclEntryPermission.EXECUTE);
        }
        return aclPermissions;
    }
}

