/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum OperatingSystem {
    WINDOWS("Windows", null),
    MACOS("MacOS", new String[]{"osx"}),
    LINUX("Linux", null),
    FREEBSD("FreeBSD", null),
    OPENBSD("OpenBSD", null),
    SOLARIS("Solaris", null);

    private final String descriptor;
    private final String[] aliases;

    private OperatingSystem(String descriptor, String[] aliases) {
        this.descriptor = descriptor;
        this.aliases = aliases;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static OperatingSystem resolve(String value) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (os.name().equalsIgnoreCase(value)) {
                return os;
            }
            if (os.getAliases() == null) continue;
            for (String alias : os.getAliases()) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return os;
            }
        }
        return null;
    }
}

