/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum OperatingSystem {
    WINDOWS(null),
    MACOS(new String[]{"osx"}),
    LINUX(null),
    FREEBSD(null),
    OPENBSD(null),
    SOLARIS(null);

    private final String[] aliases;

    private OperatingSystem(String[] aliases) {
        this.aliases = aliases;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static OperatingSystem resolve(String value) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (os.name().equalsIgnoreCase(value)) {
                return os;
            }
            if (os.getAliases() == null) continue;
            for (String alias : os.getAliases()) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return os;
            }
        }
        return null;
    }
}

