/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum HardwareArchitecture {
    X32(new String[]{"i386", "i586", "i686"}),
    X64(new String[]{"x86_64", "amd64"}),
    ARMEL(null, new String[]{"arm32v5", "arm32v6"}),
    ARMHF(null, new String[]{"arm32v7"}),
    ARM64(new String[]{"aarch64"}, new String[]{"arm64v8"}),
    RISCV64(null, new String[]{"riscv64gc"}),
    MIPS64LE(null),
    S390X(null),
    PPC64LE(null);

    private final String[] aliases;
    private final String[] extraAliases;

    private HardwareArchitecture(String[] aliases) {
        this(aliases, null);
    }

    private HardwareArchitecture(String[] aliases, String[] extraAliases) {
        this.aliases = aliases;
        this.extraAliases = extraAliases;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getExtraAliases() {
        return this.extraAliases;
    }

    public static HardwareArchitecture resolve(String value) {
        for (HardwareArchitecture arch : HardwareArchitecture.values()) {
            if (arch.name().equalsIgnoreCase(value)) {
                return arch;
            }
            if (arch.getAliases() != null) {
                for (String alias : arch.getAliases()) {
                    if (!alias.equalsIgnoreCase(value)) continue;
                    return arch;
                }
            }
            if (arch.getExtraAliases() == null) continue;
            for (String alias : arch.getExtraAliases()) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return arch;
            }
        }
        return null;
    }
}

