/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum OperatingSystem {
    ANY,
    UNKNOWN,
    WINDOWS,
    OSX,
    LINUX,
    FREEBSD,
    OPENBSD,
    SOLARIS;


    public static OperatingSystem detect() {
        return OperatingSystem.parseSystemProperty(System.getProperty("os.name"));
    }

    public static OperatingSystem parseSystemProperty(String value) {
        if (value != null) {
            if ((value = value.toLowerCase()).contains("windows")) {
                return WINDOWS;
            }
            if (value.contains("mac") || value.contains("darwin")) {
                return OSX;
            }
            if (value.contains("linux")) {
                return LINUX;
            }
            if (value.contains("sun") || value.contains("solaris")) {
                return SOLARIS;
            }
            if (value.contains("freebsd")) {
                return FREEBSD;
            }
            if (value.contains("openbsd")) {
                return OPENBSD;
            }
        }
        return UNKNOWN;
    }
}

