/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtil {
    public static File getJarFileForResource(URL resource) throws IOException {
        if (!resource.getProtocol().equalsIgnoreCase("jar")) {
            throw new IOException("Resource protocol was not jar");
        }
        String file = resource.getFile();
        int exclaimPos = file.lastIndexOf("!");
        if (exclaimPos < 0) {
            throw new IOException("Missing ! char (invalid jar resource)");
        }
        String tempJarFile = file.substring(0, exclaimPos);
        try {
            File jarFile = new File(new URL(tempJarFile).toURI());
            return jarFile;
        }
        catch (MalformedURLException e) {
            throw new IOException("Unable to create uri for jar file", e);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to create uri for jar file", e);
        }
    }

    public static String getManifestVersionNumber(File file) throws IOException {
        JarFile jar = new JarFile(file);
        Manifest manifest = jar.getManifest();
        String versionNumber = null;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            for (Attributes.Name name : attributes.keySet()) {
                String keyword = name.toString();
                if (!keyword.equals("Implementation-Version") && !keyword.equals("Bundle-Version")) continue;
                versionNumber = (String)attributes.get(name);
                break;
            }
        }
        jar.close();
        if (versionNumber == null || versionNumber.equals("")) {
            return null;
        }
        return versionNumber;
    }
}

