/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.ui.auth.core.AuthProviderType;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.TokenAuthHandler;
import java.util.HashMap;

public abstract class FirebaseAuthProvider {
    private static final String TAG = "FirebaseAuthProvider";
    private final Context mContext;
    private final AuthProviderType mAuthProviderType;
    private final String mProviderName;
    private final Firebase mRef;
    private final TokenAuthHandler mHandler;

    public abstract void logout();

    public Context getContext() {
        return this.mContext;
    }

    public AuthProviderType getProviderType() {
        return this.mAuthProviderType;
    }

    public String getProviderName() {
        return this.mProviderName;
    }

    public Firebase getFirebaseRef() {
        return this.mRef;
    }

    public TokenAuthHandler getHandler() {
        return this.mHandler;
    }

    protected FirebaseAuthProvider(Context context, AuthProviderType providerType, String providerName, Firebase ref, TokenAuthHandler handler) {
        this.mContext = context;
        this.mAuthProviderType = providerType;
        this.mProviderName = providerName;
        this.mRef = ref;
        this.mHandler = handler;
    }

    public void login() {
        Log.w((String)TAG, (String)("Login() is not supported for provider type " + this.getProviderName()));
    }

    public void login(String email, String password) {
        Log.w((String)TAG, (String)("Login(String email, String password) is not supported for provider type " + this.getProviderName()));
    }

    public void onFirebaseTokenReceived(FirebaseOAuthToken token, TokenAuthHandler handler) {
        this.authenticateRefWithOAuthFirebasetoken(token, handler);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    private void authenticateRefWithOAuthFirebasetoken(FirebaseOAuthToken token, final TokenAuthHandler handler) {
        Firebase.AuthResultHandler authResultHandler = new Firebase.AuthResultHandler(){

            public void onAuthenticated(AuthData authData) {
                handler.onSuccess(authData);
            }

            public void onAuthenticationError(FirebaseError firebaseError) {
                Log.e((String)FirebaseAuthProvider.TAG, (String)("Authentication failed: " + firebaseError.toString()));
                handler.onProviderError(new FirebaseLoginError(FirebaseResponse.PROVIDER_NOT_ENABLED, "Make sure " + FirebaseAuthProvider.this.getProviderName() + " login is enabled and configured in your Firebase. (" + firebaseError.toString() + ")"));
            }
        };
        if (token.mode == 1) {
            this.getFirebaseRef().authWithOAuthToken(token.provider, token.token, authResultHandler);
        } else if (token.mode == 2) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("oauth_token", token.token);
            options.put("oauth_token_secret", token.secret);
            options.put("user_id", token.uid);
            this.getFirebaseRef().authWithOAuthToken(token.provider, options, authResultHandler);
        }
    }
}

