/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.twitter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.firebase.client.Firebase;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import com.firebase.ui.auth.twitter.TwitterActions;
import com.firebase.ui.auth.twitter.TwitterPromptActivity;

public class TwitterAuthProvider
extends FirebaseAuthProvider {
    public static final String TAG = "TwitterAuthProvider";
    public static final String PROVIDER_NAME = "twitter";
    public static final SocialProvider PROVIDER_TYPE = SocialProvider.twitter;
    private Activity mActivity;
    private TokenAuthHandler mHandler;
    private Firebase mRef;

    public TwitterAuthProvider(Context context, Firebase ref, TokenAuthHandler handler) {
        this.mActivity = (Activity)context;
        this.mHandler = handler;
        this.mRef = ref;
    }

    @Override
    public void login() {
        this.mActivity.startActivityForResult(new Intent((Context)this.mActivity, TwitterPromptActivity.class), TwitterActions.REQUEST);
    }

    @Override
    public void logout() {
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public Firebase getFirebaseRef() {
        return this.mRef;
    }

    @Override
    public SocialProvider getProviderType() {
        return PROVIDER_TYPE;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == TwitterActions.SUCCESS) {
            FirebaseOAuthToken token = new FirebaseOAuthToken(PROVIDER_NAME, data.getStringExtra("oauth_token"), data.getStringExtra("oauth_token_secret"), data.getStringExtra("user_id"));
            this.onFirebaseTokenReceived(token, this.mHandler);
        } else if (resultCode == TwitterActions.USER_ERROR) {
            FirebaseResponse error = FirebaseResponse.values()[data.getIntExtra("code", 0)];
            this.mHandler.onUserError(new FirebaseLoginError(error, data.getStringExtra("error")));
        } else if (resultCode == TwitterActions.PROVIDER_ERROR) {
            FirebaseResponse error = FirebaseResponse.values()[data.getIntExtra("code", 0)];
            this.mHandler.onProviderError(new FirebaseLoginError(error, data.getStringExtra("error")));
        }
    }
}

